const {Insumo, SubCategoriaInventario, CategoriaInventario} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todos los Insumos
exports.getInsumoAll = async (req, res) => {
  try {
    const insumos = await Insumo.findAll(
      {
        include: [
          {
            model: SubCategoriaInventario,
            as: 'subcategoria',
            include: [
              {
                model: CategoriaInventario,
                as: 'categoria'
              }
            ]
          }
        ],
        order: [['Nombre', 'ASC']]
      }
    );
    logger.info("Insumos obtenidos correctamente");
    res.json(insumos);
  } catch (error) {
    logger.error("Error al obtener Insumos: " + error.message);
    res.status(500).json({ error: "Error al obtener Insumos" });
  }
};

// Obtener todos los Insumos por categoria
exports.getInsumoByCategoria = async (req, res) => {
  try {
    const { categoria } = req.params; 
    const insumos = await Insumo.findAll(
      {
        include: [
          {
            model: SubCategoriaInventario,
            as: 'subcategoria',
            include: [
              {
                model: CategoriaInventario,
                as: 'categoria'
              }
            ]
          }
        ],
        order: [['Nombre', 'ASC']]
      }
    );
    logger.info("Insumos obtenidos correctamente");
    res.json(insumos);
  } catch (error) {
    logger.error("Error al obtener Insumos: " + error.message);
    res.status(500).json({ error: "Error al obtener Insumoes" });
  }
};

// Obtener todos los Insumos por subcategoria
exports.getInsumoBySubCategoria = async (req, res) => {
  try {
    const { subcategoria } = req.params; 
    const insumos = await Insumo.findAll(
      {
        where: {
          SubCategoriaInventarioId: subcategoria
        },
        include: [
          {
            model: SubCategoriaInventario,
            as: 'subcategoria',
            include: [
              {
                model: CategoriaInventario,
                as: 'categoria'
              }
            ]
          }
        ],
        order: [['Nombre', 'ASC']]
      }
    );
    logger.info("Insumos obtenidos correctamente");
    res.json(insumos);
  } catch (error) {
    logger.error("Error al obtener Insumos: " + error.message);
    res.status(500).json({ error: "Error al obtener Insumoes" });
  }
};

// Obtener una Insumo por ID
exports.getInsumoById = async (req, res) => {
  try {
    const insumo = await Insumo.findByPk(req.params.id);
    if (!insumo) {
      logger.error("Insumo no encontrada por su ID");
      return res.status(404).json({ error: "Insumo no encontrada" });
    }
    logger.info("Insumo obtenido correctamente por su ID");
    res.json(insumo);
  } catch (error) {
    logger.error("Error al obtener el Insumo mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Insumo" });
  }
};

// Crear una Insumo
exports.createInsumo = async (req, res) => {
  try {
    const insumo = await Insumo.create(req.body);
    logger.info("Insumos creado correctamente");
    res.status(201).json(insumo);
  } catch (error) {
    logger.error("Error al crear un Insumo: " + error.message);
    res.status(500).json({ error: "Error al crear Insumo" });
  }
};

// Actualizar una Insumo
exports.updateInsumo = async (req, res) => {
  try {
    const insumo = await Insumo.findByPk(req.params.id);
    if (!insumo) {
      logger.error("Insumo no encontrada por su ID");
      return res.status(404).json({ error: "Insumo no encontrada" });
    }
    await insumo.update(req.body);
    logger.info("Insumos actualizado correctamente");
    res.json(insumo);
  } catch (error) {
    logger.error("Error al actualizar un Insumo: " + error.message);
    res.status(500).json({ error: "Error al actualizar Insumo" });
  }
};

// Eliminar una Insumo
exports.deleteInsumo = async (req, res) => {
  try {
    const insumo = await Insumo.findByPk(req.params.id);
    if (!insumo) {
      logger.error("Insumo no encontrada por su ID");
      return res.status(404).json({ error: "Insumo no encontrada" });
    }
    await Insumo.destroy();
    logger.info("Insumos eliminado correctamente");
    res.json({ message: "Insumo eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Insumo: " + error.message);
    res.status(500).json({ error: "Error al eliminar Insumo" });
  }
};

