const {ItemFactura} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las ItemFacturaes
exports.getItemFacturaAll = async (req, res) => {
  try {
    const items = await ItemFactura.findAll();
    logger.info("ItemFacturas obtenidos correctamente");
    res.json(items);
  } catch (error) {
    logger.error("Error al obtener ItemFacturas: " + error.message);
    res.status(500).json({ error: "Error al obtener ItemFacturaes" });
  }
};

// Filtrar ItemFacturaes por Factura
exports.getItemFacturaByFactura = async (req, res) => {
  try {
    const { factura } = req.params;
    const items = await ItemFactura.findAll(
      {
        where: {
          FacturaId: factura
        }
      }
    );

    res.json(items);
  } catch (error) {
    res.status(500).json({ error: "Error al filtrar ItemFacturaes por odontólogo" });
  }
};

// Filtrar ItemFacturaes por Tarifario
exports.getItemFacturaByTarifario = async (req, res) => {
  try {
    const { tarifario } = req.params;
    const items = await ItemFactura.findAll(
      {
        where: {
          TarifarioId: tarifario
        }
      }
    );

    res.json(items);
  } catch (error) {
    res.status(500).json({ error: "Error al filtrar ItemFacturaes por odontólogo" });
  }
};

// Obtener una ItemFactura por ID
exports.getItemFacturaById = async (req, res) => {
  try {
    const item = await ItemFactura.findByPk(req.params.id);
    if (!item) {
      logger.error("ItemFactura no encontrada por su ID");
      return res.status(404).json({ error: "ItemFactura no encontrada" });
    }
    logger.info("ItemFactura obtenido correctamente por su ID");
    res.json(item);
  } catch (error) {
    logger.error("Error al obtener el ItemFactura mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener ItemFactura" });
  }
};

// Crear una ItemFactura
exports.createItemFactura = async (req, res) => {
  try {
    const item = await ItemFactura.create(req.body);
    logger.info("ItemFacturas creado correctamente");
    res.status(201).json(item);
  } catch (error) {
    logger.error("Error al crear un ItemFactura: " + error.message);
    res.status(500).json({ error: "Error al crear ItemFactura" });
  }
};

// Actualizar una ItemFactura
exports.updateItemFactura = async (req, res) => {
  try {
    const item = await ItemFactura.findByPk(req.params.id);
    if (!item) {
      logger.error("ItemFactura no encontrada por su ID");
      return res.status(404).json({ error: "ItemFactura no encontrada" });
    }
    await item.update(req.body);
    logger.info("ItemFacturas actualizado correctamente");
    res.json(item);
  } catch (error) {
    logger.error("Error al actualizar un ItemFactura: " + error.message);
    res.status(500).json({ error: "Error al actualizar ItemFactura" });
  }
};

// Eliminar una ItemFactura
exports.deleteItemFactura = async (req, res) => {
  try {
    const item = await ItemFactura.findByPk(req.params.id);
    if (!item) {
      logger.error("ItemFactura no encontrada por su ID");
      return res.status(404).json({ error: "ItemFactura no encontrada" });
    }
    await ItemFactura.destroy();
    logger.info("ItemFacturas eliminado correctamente");
    res.json({ message: "ItemFactura eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un ItemFactura: " + error.message);
    res.status(500).json({ error: "Error al eliminar ItemFactura" });
  }
};
