const {ItemLaboratorio, Laboratorio} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las ItemRadiografiaes
exports.getItemLaboratorioAll = async (req, res) => {
  try {
    const datos = await ItemLaboratorio.findAll(
      {
        include: [
          {
            model: Laboratorio,
            as: "laboratorio",
          }
        ]
      }
    );
    logger.info("ItemLaboratorio obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener ItemLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al obtener ItemLaboratorios" });
  }
};

// Obtener una ItemLaboratorio por Empresa
exports.getItemLaboratorioByLaboratorio = async (req, res) => {
  try {
    const { laboratorio } = req.params;
    const datos = await ItemLaboratorio.findAll(
      {
        where: {
          LaboratorioId: laboratorio
        },
        include: [
          {
            model: Laboratorio,
            as: "laboratorio",
          }
        ]
      }
    );
    if (!datos) {
      logger.error("ItemLaboratorio no encontrada por su asociacion con paciente");
      return res.status(404).json({ error: "ItemLaboratorios no encontrada" });
    }
    logger.info("ItemLaboratorios obtenidas correctamente por su asociacion con el paciente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el ItemLaboratorio mediante por paciente: " + error.message);
    res.status(500).json({ error: "Error al obtener ItemLaboratorios" });
  }
};

// Obtener una ItemLaboratorio por ID
exports.getItemLaboratorioById = async (req, res) => {
  try {
    const dato = await ItemLaboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("ItemLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "ItemLaboratorio no encontrada" });
    }
    logger.info("ItemLaboratorio obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el ItemLaboratorio mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener ItemLaboratorio" });
  }
};

// Crear una ItemLaboratorio
exports.createItemLaboratorio = async (req, res) => {
  try {
    const dato = await ItemLaboratorio.create(req.body);
    logger.info("ItemLaboratorios creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un ItemLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al crear ItemLaboratorio" });
  }
};

// Actualizar una ItemLaboratorio
exports.updateItemLaboratorio = async (req, res) => {
  try {
    const dato = await ItemLaboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("ItemLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "ItemLaboratorio no encontrada" });
    }
    await dato.update(req.body);
    logger.info("ItemLaboratorio actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un ItemLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al actualizar ItemLaboratorio" });
  }
};

// Eliminar una ItemLaboratorio
exports.deleteItemLaboratorio = async (req, res) => {
  try {
    const dato = await ItemLaboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("ItemLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "ItemLaboratorio no encontrada" });
    }
    await ItemLaboratorio.destroy();
    logger.info("ItemLaboratorio eliminado correctamente");
    res.json({ message: "ItemLaboratorio eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un ItemLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al eliminar ItemLaboratorio" });
  }
};

