const {ItemRadiografia, Radiografia} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las ItemRadiografiaes
exports.getItemRadiografiaAll = async (req, res) => {
  try {
    const datos = await ItemRadiografia.findAll(
      {
        include: [
          {
            model: Radiografia,
            as: "radiografia",
          }
        ]
      }
    );
    logger.info("ItemRadiografias obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener ItemRadiografias: " + error.message);
    res.status(500).json({ error: "Error al obtener ItemRadiografiaes" });
  }
};
// Obtener una ItemRadiografia por Empresa
exports.getItemRadiografiaByRadiografia = async (req, res) => {
  try {
    const { radiografia } = req.params;
    const datos = await ItemRadiografia.findAll(
      {
        where: {
          RadiografiaId: radiografia
        },
        include: [
          {
            model: Radiografia,
            as: "radiografia",
          }
        ]
      }
    );
    if (!datos) {
      logger.error("ItemRadiografia no encontrada por su asociacion con paciente");
      return res.status(404).json({ error: "ItemRadiografias no encontrada" });
    }
    logger.info("ItemRadiografias obtenidas correctamente por su asociacion con el paciente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el ItemRadiografia mediante por paciente: " + error.message);
    res.status(500).json({ error: "Error al obtener ItemRadiografias" });
  }
};

// Obtener una ItemRadiografia por ID
exports.getItemRadiografiaById = async (req, res) => {
  try {
    const dato = await ItemRadiografia.findByPk(req.params.id);
    if (!dato) {
      logger.error("ItemRadiografia no encontrada por su ID");
      return res.status(404).json({ error: "ItemRadiografia no encontrada" });
    }
    logger.info("ItemRadiografia obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el ItemRadiografia mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener ItemRadiografia" });
  }
};

// Crear una ItemRadiografia
exports.createItemRadiografia = async (req, res) => {
  try {
    const dato = await ItemRadiografia.create(req.body);
    logger.info("ItemRadiografias creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un ItemRadiografia: " + error.message);
    res.status(500).json({ error: "Error al crear ItemRadiografia" });
  }
};

// Actualizar una ItemRadiografia
exports.updateItemRadiografia = async (req, res) => {
  try {
    const dato = await ItemRadiografia.findByPk(req.params.id);
    if (!dato) {
      logger.error("ItemRadiografia no encontrada por su ID");
      return res.status(404).json({ error: "ItemRadiografia no encontrada" });
    }
    await dato.update(req.body);
    logger.info("ItemRadiografia actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un ItemRadiografia: " + error.message);
    res.status(500).json({ error: "Error al actualizar ItemRadiografia" });
  }
};

// Eliminar una ItemRadiografia
exports.deleteItemRadiografia = async (req, res) => {
  try {
    const dato = await ItemRadiografia.findByPk(req.params.id);
    if (!dato) {
      logger.error("ItemRadiografia no encontrada por su ID");
      return res.status(404).json({ error: "ItemRadiografia no encontrada" });
    }
    await ItemRadiografia.destroy();
    logger.info("ItemRadiografia eliminado correctamente");
    res.json({ message: "ItemRadiografia eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un ItemRadiografia: " + error.message);
    res.status(500).json({ error: "Error al eliminar ItemRadiografia" });
  }
};

