const {ItemReceta} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las ItemRecetaes
exports.getItemRecetaAll = async (req, res) => {
  try {
    const datos = await ItemReceta.findAll();
    logger.info("ItemRecetas obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener ItemRecetas: " + error.message);
    res.status(500).json({ error: "Error al obtener ItemRecetaes" });
  }
};

// Obtener ItemReceta por Receta
exports.getItemRecetaByReceta = async (req, res) => {
  try {
    const { receta } = req.params;
    const datos = await ItemReceta.findAll(
      {
        where: {
          RecetaId: receta
        }
      }
    );
    if (!datos) {
      logger.error("ItemReceta no encontrada por su asociacion con Receta");
      return res.status(404).json({ error: "ItemRecetas no encontrada" });
    }
    logger.info("ItemRecetas obtenidas correctamente por su asociacion con la Receta");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el ItemReceta mediante por Receta: " + error.message);
    res.status(500).json({ error: "Error al obtener ItemRecetas" });
  }
};

// Obtener una ItemReceta por ID
exports.getItemRecetaById = async (req, res) => {
  try {
    const dato = await ItemReceta.findByPk(req.params.id);
    if (!dato) {
      logger.error("ItemReceta no encontrada por su ID");
      return res.status(404).json({ error: "ItemReceta no encontrada" });
    }
    logger.info("ItemReceta obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el ItemReceta mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener ItemReceta" });
  }
};

// Crear una ItemReceta
exports.createItemReceta = async (req, res) => {
  try {
    const dato = await ItemReceta.create(req.body);
    logger.info("ItemRecetas creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un ItemReceta: " + error.message);
    res.status(500).json({ error: "Error al crear ItemReceta" });
  }
};

// Actualizar una ItemReceta
exports.updateItemReceta = async (req, res) => {
  try {
    const dato = await ItemReceta.findByPk(req.params.id);
    if (!dato) {
      logger.error("ItemReceta no encontrada por su ID");
      return res.status(404).json({ error: "ItemReceta no encontrada" });
    }
    await dato.update(req.body);
    logger.info("ItemRecetas actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un ItemReceta: " + error.message);
    res.status(500).json({ error: "Error al actualizar ItemReceta" });
  }
};

// Eliminar una ItemReceta
exports.deleteItemReceta = async (req, res) => {
  try {
    const dato = await ItemReceta.findByPk(req.params.id);
    if (!dato) {
      logger.error("ItemReceta no encontrada por su ID");
      return res.status(404).json({ error: "ItemReceta no encontrada" });
    }
    await ItemReceta.destroy();
    logger.info("ItemRecetas eliminado correctamente");
    res.json({ message: "ItemReceta eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un ItemReceta: " + error.message);
    res.status(500).json({ error: "Error al eliminar ItemReceta" });
  }
};

