const {ItemResultadoLaboratorio} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las ItemResultadoLaboratorioes
exports.getItemResultadoLaboratorioAll = async (req, res) => {
  try {
    const datos = await ItemResultadoLaboratorio.findAll();
    logger.info("ItemResultadoLaboratorios obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener ItemResultadoLaboratorios: " + error.message);
    res.status(500).json({ error: "Error al obtener ItemResultadoLaboratorioes" });
  }
};
// Obtener una ItemResultadoLaboratorio por Peticion LaboratorioId
exports.getItemResultadoLaboratorioByPeticionLaboratorio = async (req, res) => {
  try {
    const { peticion } = req.params;
    const datos = await ItemResultadoLaboratorio.findAll(
      {
        where: {
          PeticionLaboratorioId: peticion
        }
      }
    );
    if (!datos) {
      logger.error("ItemResultadoLaboratorio no encontrada por su asociacion con paciente");
      return res.json(null);
    }
    logger.info("ItemResultadoLaboratorios obtenidas correctamente por su asociacion con el paciente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el ItemResultadoLaboratorio mediante por paciente: " + error.message);
    res.status(500).json({ error: "Error al obtener ItemResultadoLaboratorios" });
  }
};
// Obtener una ItemResultadoLaboratorio por Empresa
exports.getItemResultadoLaboratorioBySubItem = async (req, res) => {
  try {
    const { subitem } = req.params;
    const datos = await ItemResultadoLaboratorio.findAll(
      {
        where: {
          SubItemLaboratorioId: subitem
        }
      }
    );
    if (!datos) {
      logger.error("ItemResultadoLaboratorio no encontrada por su asociacion con paciente");
      return res.status(404).json({ error: "ItemResultadoLaboratorios no encontrada" });
    }
    logger.info("ItemResultadoLaboratorios obtenidas correctamente por su asociacion con el paciente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el ItemResultadoLaboratorio mediante por paciente: " + error.message);
    res.status(500).json({ error: "Error al obtener ItemResultadoLaboratorios" });
  }
};
// Obtener una ItemResultadoLaboratorio por Empresa
exports.getItemResultadoLaboratorioByResultadoLaboratorio = async (req, res) => {
  try {
    const { resultadolaboratorio } = req.params;
    const datos = await ItemResultadoLaboratorio.findAll(
      {
        where: {
          ResultadoLaboratorioId: resultadolaboratorio
        }
      }
    );
    if (!datos) {
      logger.error("ItemResultadoLaboratorio no encontrada por su asociacion con paciente");
      return res.status(404).json({ error: "ItemResultadoLaboratorios no encontrada" });
    }
    logger.info("ItemResultadoLaboratorios obtenidas correctamente por su asociacion con el paciente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el ItemResultadoLaboratorio mediante por paciente: " + error.message);
    res.status(500).json({ error: "Error al obtener ItemResultadoLaboratorios" });
  }
};

// Obtener una ItemResultadoLaboratorio por ID
exports.getItemResultadoLaboratorioById = async (req, res) => {
  try {
    const dato = await ItemResultadoLaboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("ItemResultadoLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "ItemResultadoLaboratorio no encontrada" });
    }
    logger.info("ItemResultadoLaboratorio obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el ItemResultadoLaboratorio mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener ItemResultadoLaboratorio" });
  }
};

// Crear una ItemResultadoLaboratorio
exports.createItemResultadoLaboratorio = async (req, res) => {
  try {
    const dato = await ItemResultadoLaboratorio.create(req.body);
    logger.info("ItemResultadoLaboratorios creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un ItemResultadoLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al crear ItemResultadoLaboratorio" });
  }
};

// Actualizar una ItemResultadoLaboratorio
exports.updateItemResultadoLaboratorio = async (req, res) => {
  try {
    const dato = await ItemResultadoLaboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("ItemResultadoLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "ItemResultadoLaboratorio no encontrada" });
    }
    await dato.update(req.body);
    logger.info("ItemResultadoLaboratorio actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un ItemResultadoLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al actualizar ItemResultadoLaboratorio" });
  }
};

// Eliminar una ItemResultadoLaboratorio
exports.deleteItemResultadoLaboratorio = async (req, res) => {
  try {
    const dato = await ItemResultadoLaboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("ItemResultadoLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "ItemResultadoLaboratorio no encontrada" });
    }
    await ItemResultadoLaboratorio.destroy();
    logger.info("ItemResultadoLaboratorio eliminado correctamente");
    res.json({ message: "ItemResultadoLaboratorio eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un ItemResultadoLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al eliminar ItemResultadoLaboratorio" });
  }
};

