const {ItemResultadoRadiografia} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las ItemResultadoRadiografiaes
exports.getItemResultadoRadiografiaAll = async (req, res) => {
  try {
    const datos = await ItemResultadoRadiografia.findAll();
    logger.info("ItemResultadoRadiografias obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener ItemResultadoRadiografias: " + error.message);
    res.status(500).json({ error: "Error al obtener ItemResultadoRadiografiaes" });
  }
};
// Obtener una ItemResultadoRadiografia por Peticion Radiografia
exports.getItemResultadoRadiografiaByPeticionRadiografia = async (req, res) => {
  try {
    const { peticion } = req.params;
    const datos = await ItemResultadoRadiografia.findAll(
      {
        where: {
          PeticionRadiografiaId: peticion
        }
      }
    );
    if (!datos) {
      logger.error("ItemResultadoRadiografia no encontrada por su asociacion con paciente");
      return res.json(null);
    }
    logger.info("ItemResultadoRadiografias obtenidas correctamente por su asociacion con el paciente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el ItemResultadoRadiografia mediante por paciente: " + error.message);
    res.status(500).json({ error: "Error al obtener ItemResultadoRadiografias" });
  }
};

// Obtener una ItemResultadoRadiografia por Resultado Radiografia
exports.getItemResultadoRadiografiaByResultadoRadiografia = async (req, res) => {
  try {
    const { resultado } = req.params;
    const datos = await ItemResultadoRadiografia.findAll(
      {
        where: {
          ResultadoRadiografiaId: resultado
        }
      }
    );
    if (!datos) {
      logger.error("ItemResultadoRadiografia no encontrada por su asociacion con paciente");
      return res.status(404).json({ error: "ItemResultadoRadiografias no encontrada" });
    }
    logger.info("ItemResultadoRadiografias obtenidas correctamente por su asociacion con el paciente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el ItemResultadoRadiografia mediante por paciente: " + error.message);
    res.status(500).json({ error: "Error al obtener ItemResultadoRadiografias" });
  }
};

// Obtener una ItemResultadoRadiografia por ID
exports.getItemResultadoRadiografiaById = async (req, res) => {
  try {
    const dato = await ItemResultadoRadiografia.findByPk(req.params.id);
    if (!dato) {
      logger.error("ItemResultadoRadiografia no encontrada por su ID");
      return res.status(404).json({ error: "ItemResultadoRadiografia no encontrada" });
    }
    logger.info("ItemResultadoRadiografia obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el ItemResultadoRadiografia mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener ItemResultadoRadiografia" });
  }
};

// Crear una ItemResultadoRadiografia
exports.createItemResultadoRadiografia = async (req, res) => {
  try {
    const dato = await ItemResultadoRadiografia.create(req.body);
    logger.info("ItemResultadoRadiografias creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un ItemResultadoRadiografia: " + error.message);
    res.status(500).json({ error: "Error al crear ItemResultadoRadiografia" });
  }
};

// Actualizar una ItemResultadoRadiografia
exports.updateItemResultadoRadiografia = async (req, res) => {
  try {
    const dato = await ItemResultadoRadiografia.findByPk(req.params.id);
    if (!dato) {
      logger.error("ItemResultadoRadiografia no encontrada por su ID");
      return res.status(404).json({ error: "ItemResultadoRadiografia no encontrada" });
    }
    await dato.update(req.body);
    logger.info("ItemResultadoRadiografia actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un ItemResultadoRadiografia: " + error.message);
    res.status(500).json({ error: "Error al actualizar ItemResultadoRadiografia" });
  }
};

// Eliminar una ItemResultadoRadiografia
exports.deleteItemResultadoRadiografia = async (req, res) => {
  try {
    const dato = await ItemResultadoRadiografia.findByPk(req.params.id);
    if (!dato) {
      logger.error("ItemResultadoRadiografia no encontrada por su ID");
      return res.status(404).json({ error: "ItemResultadoRadiografia no encontrada" });
    }
    await ItemResultadoRadiografia.destroy();
    logger.info("ItemResultadoRadiografia eliminado correctamente");
    res.json({ message: "ItemResultadoRadiografia eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un ItemResultadoRadiografia: " + error.message);
    res.status(500).json({ error: "Error al eliminar ItemResultadoRadiografia" });
  }
};

