const {Laboratorio} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Laboratorioes
exports.getLaboratorioAll = async (req, res) => {
  try {
    const datos = await Laboratorio.findAll();
    logger.info("Laboratorios obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener Laboratorios: " + error.message);
    res.status(500).json({ error: "Error al obtener Laboratorioes" });
  }
};
// Obtener una Laboratorio por ID
exports.getLaboratorioById = async (req, res) => {
  try {
    const dato = await Laboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("Laboratorio no encontrada por su ID");
      return res.status(404).json({ error: "Laboratorio no encontrada" });
    }
    logger.info("Laboratorio obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el Laboratorio mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Laboratorio" });
  }
};

// Crear una Laboratorio
exports.createLaboratorio = async (req, res) => {
  try {
    const dato = await Laboratorio.create(req.body);
    logger.info("Laboratorios creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un Laboratorio: " + error.message);
    res.status(500).json({ error: "Error al crear Laboratorio" });
  }
};

// Actualizar una Laboratorio
exports.updateLaboratorio = async (req, res) => {
  try {
    const dato = await Laboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("Laboratorio no encontrada por su ID");
      return res.status(404).json({ error: "Laboratorio no encontrada" });
    }
    await dato.update(req.body);
    logger.info("Laboratorios actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un Laboratorio: " + error.message);
    res.status(500).json({ error: "Error al actualizar Laboratorio" });
  }
};

// Eliminar una Laboratorio
exports.deleteLaboratorio = async (req, res) => {
  try {
    const dato = await Laboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("Laboratorio no encontrada por su ID");
      return res.status(404).json({ error: "Laboratorio no encontrada" });
    }
    await Laboratorio.destroy();
    logger.info("Laboratorios eliminado correctamente");
    res.json({ message: "Laboratorio eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Laboratorio: " + error.message);
    res.status(500).json({ error: "Error al eliminar Laboratorio" });
  }
};

