const {OdontogramaClinico} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las OdontogramaClinicoes
exports.getOdontogramaClinicoAll = async (req, res) => {
  try {
    const dato = await OdontogramaClinico.findAll();
    logger.info("OdontogramaClinicos obtenidos correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener OdontogramaClinicos: " + error.message);
    res.status(500).json({ error: "Error al obtener OdontogramaClinicoes" });
  }
};

// Obtener OdontogramaClinico por Historia Clinica
exports.getOdontogramaClinicoByPaciente = async (req, res) => {
  try {
    const { paciente } = req.params;
    const datos = await OdontogramaClinico.findAll(
      {
        where: {
          PacienteId: paciente
        },
        exclude: ["Imagen"],
      }
    );
    if (!datos) {
      logger.error("OdontogramaClinico no encontrada por su asociacion con Historia Clinica");
      return res.status(404).json({ error: "OdontogramaClinicos no encontrada" });
    }
    logger.info("OdontogramaClinicos obtenidas correctamente por su asociacion con la Historia Clinica");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el OdontogramaClinico mediante por Historia Clinica: " + error.message);
    res.status(500).json({ error: "Error al obtener OdontogramaClinicos" });
  }
};

// Obtener una OdontogramaClinico por ID
exports.getOdontogramaClinicoById = async (req, res) => {
  try {
    const dato = await OdontogramaClinico.findByPk(req.params.id);
    if (!dato) {
      logger.error("OdontogramaClinico no encontrada por su ID");
      return res.status(404).json({ error: "OdontogramaClinico no encontrada" });
    }
    logger.info("OdontogramaClinico obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el OdontogramaClinico mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener OdontogramaClinico" });
  }
};

// Crear una OdontogramaClinico
exports.createOdontogramaClinico = async (req, res) => {
  try {
    const dato = await OdontogramaClinico.create(req.body);
    logger.info("OdontogramaClinicos creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un OdontogramaClinico: " + error.message);
    res.status(500).json({ error: "Error al crear OdontogramaClinico" });
  }
};

// Actualizar una OdontogramaClinico
exports.updateOdontogramaClinico = async (req, res) => {
  try {
    const dato = await OdontogramaClinico.findByPk(req.params.id);
    if (!dato) {
      logger.error("OdontogramaClinico no encontrada por su ID");
      return res.status(404).json({ error: "OdontogramaClinico no encontrada" });
    }
    await dato.update(req.body);
    logger.info("OdontogramaClinicos actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un OdontogramaClinico: " + error.message);
    res.status(500).json({ error: "Error al actualizar OdontogramaClinico" });
  }
};

// Eliminar una OdontogramaClinico
exports.deleteOdontogramaClinico = async (req, res) => {
  try {
    const dato = await OdontogramaClinico.findByPk(req.params.id);
    if (!dato) {
      logger.error("OdontogramaClinico no encontrada por su ID");
      return res.status(404).json({ error: "OdontogramaClinico no encontrada" });
    }
    await OdontogramaClinico.destroy();
    logger.info("OdontogramaClinicos eliminado correctamente");
    res.json({ message: "OdontogramaClinico eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un OdontogramaClinico: " + error.message);
    res.status(500).json({ error: "Error al eliminar OdontogramaClinico" });
  }
};

