const {OdontogramaEconomico} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las OdontogramaEconomicoes
exports.getOdontogramaEconomicoAll = async (req, res) => {
  try {
    const dato = await OdontogramaEconomico.findAll();
    logger.info("OdontogramaEconomicos obtenidos correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener OdontogramaEconomicos: " + error.message);
    res.status(500).json({ error: "Error al obtener OdontogramaEconomicoes" });
  }
};

// Obtener OdontogramaEconomico por Historia Clinica
exports.getOdontogramaEconomicoByPaciente = async (req, res) => {
  try {
    const { paciente } = req.params;
    const datos = await OdontogramaEconomico.findAll(
      {
        where: {
          PacienteId: paciente
        }
      }
    );
    if (!datos) {
      logger.error("OdontogramaEconomico no encontrada por su asociacion con paciente");
      return res.status(404).json({ error: "OdontogramaEconomicos no encontrada" });
    }
    logger.info("OdontogramaEconomicos obtenidas correctamente por su asociacion con paciente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el OdontogramaEconomico mediante por paciente: " + error.message);
    res.status(500).json({ error: "Error al obtener OdontogramaEconomicos" });
  }
};

// Obtener OdontogramaEconomico por Historia Clinica
exports.getOdontogramaEconomicoByFactura = async (req, res) => {
  try {
    const { factura } = req.params;
    const dato = await OdontogramaEconomico.findOne(
      {
        where: {
          FacturaId: factura
        }
      }
    );
    if (!dato) {
      logger.error("OdontogramaEconomico no encontrada por su asociacion con factura");
      return res.status(404).json({ error: "OdontogramaEconomicos no encontrada" });
    }
    logger.info("OdontogramaEconomicos obtenidas correctamente por su asociacion con la factura");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el OdontogramaEconomico mediante por factura: " + error.message);
    res.status(500).json({ error: "Error al obtener OdontogramaEconomicos" });
  }
};

// Obtener una OdontogramaEconomico por ID
exports.getOdontogramaEconomicoById = async (req, res) => {
  try {
    const dato = await OdontogramaEconomico.findByPk(req.params.id);
    if (!dato) {
      logger.error("OdontogramaEconomico no encontrada por su ID");
      return res.status(404).json({ error: "OdontogramaEconomico no encontrada" });
    }
    logger.info("OdontogramaEconomico obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el OdontogramaEconomico mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener OdontogramaEconomico" });
  }
};

// Crear una OdontogramaEconomico
exports.createOdontogramaEconomico = async (req, res) => {
  try {
    const dato = await OdontogramaEconomico.create(req.body);
    logger.info("OdontogramaEconomicos creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un OdontogramaEconomico: " + error.message);
    res.status(500).json({ error: "Error al crear OdontogramaEconomico" });
  }
};

// Actualizar una OdontogramaEconomico
exports.updateOdontogramaEconomico = async (req, res) => {
  try {
    const dato = await OdontogramaEconomico.findByPk(req.params.id);
    if (!dato) {
      logger.error("OdontogramaEconomico no encontrada por su ID");
      return res.status(404).json({ error: "OdontogramaEconomico no encontrada" });
    }
    await dato.update(req.body);
    logger.info("OdontogramaEconomicos actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un OdontogramaEconomico: " + error.message);
    res.status(500).json({ error: "Error al actualizar OdontogramaEconomico" });
  }
};

// Eliminar una OdontogramaEconomico
exports.deleteOdontogramaEconomico = async (req, res) => {
  try {
    const dato = await OdontogramaEconomico.findByPk(req.params.id);
    if (!dato) {
      logger.error("OdontogramaEconomico no encontrada por su ID");
      return res.status(404).json({ error: "OdontogramaEconomico no encontrada" });
    }
    await OdontogramaEconomico.destroy();
    logger.info("OdontogramaEconomicos eliminado correctamente");
    res.json({ message: "OdontogramaEconomico eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un OdontogramaEconomico: " + error.message);
    res.status(500).json({ error: "Error al eliminar OdontogramaEconomico" });
  }
};

