const {OrdenLaboratorio} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las OrdenLaboratorioes
exports.getOrdenLaboratorioAll = async (req, res) => {
  try {
    const datos = await OrdenLaboratorio.findAll();
    logger.info("OrdenLaboratorios obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener OrdenLaboratorios: " + error.message);
    res.status(500).json({ error: "Error al obtener OrdenLaboratorioes" });
  }
};
// Obtener una OrdenLaboratorio por Empresa
exports.getOrdenLaboratorioByPaciente = async (req, res) => {
  try {
    const { paciente } = req.params;
    const datos = await OrdenLaboratorio.findAll(
      {
        where: {
          PacienteId: paciente
        }
      }
    );
    if (!datos) {
      logger.error("OrdenLaboratorio no encontrada por su asociacion con paciente");
      return res.status(404).json({ error: "OrdenLaboratorios no encontrada" });
    }
    logger.info("OrdenLaboratorios obtenidas correctamente por su asociacion con el paciente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el OrdenLaboratorio mediante por paciente: " + error.message);
    res.status(500).json({ error: "Error al obtener OrdenLaboratorios" });
  }
};

// Obtener una OrdenLaboratorio por ID
exports.getOrdenLaboratorioById = async (req, res) => {
  try {
    const dato = await OrdenLaboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("OrdenLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "OrdenLaboratorio no encontrada" });
    }
    logger.info("OrdenLaboratorio obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el OrdenLaboratorio mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener OrdenLaboratorio" });
  }
};

// Crear una OrdenLaboratorio
exports.createOrdenLaboratorio = async (req, res) => {
  try {
    const dato = await OrdenLaboratorio.create(req.body);
    logger.info("OrdenLaboratorios creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un OrdenLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al crear OrdenLaboratorio" });
  }
};

// Actualizar una OrdenLaboratorio
exports.updateOrdenLaboratorio = async (req, res) => {
  try {
    const dato = await OrdenLaboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("OrdenLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "OrdenLaboratorio no encontrada" });
    }
    await dato.update(req.body);
    logger.info("OrdenLaboratorio actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un OrdenLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al actualizar OrdenLaboratorio" });
  }
};

// Eliminar una OrdenLaboratorio
exports.deleteOrdenLaboratorio = async (req, res) => {
  try {
    const dato = await OrdenLaboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("OrdenLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "OrdenLaboratorio no encontrada" });
    }
    await OrdenLaboratorio.destroy();
    logger.info("OrdenLaboratorio eliminado correctamente");
    res.json({ message: "OrdenLaboratorio eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un OrdenLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al eliminar OrdenLaboratorio" });
  }
};

