const {OrdenRadiografia} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las OrdenRadiografiaes
exports.getOrdenRadiografiaAll = async (req, res) => {
  try {
    const datos = await OrdenRadiografia.findAll();
    logger.info("OrdenRadiografias obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener OrdenRadiografias: " + error.message);
    res.status(500).json({ error: "Error al obtener OrdenRadiografiaes" });
  }
};
// Obtener una OrdenRadiografia por Empresa
exports.getOrdenRadiografiaByPaciente = async (req, res) => {
  try {
    const { paciente } = req.params;
    const datos = await OrdenRadiografia.findAll(
      {
        where: {
          PacienteId: paciente
        }
      }
    );
    if (!datos) {
      logger.error("OrdenRadiografia no encontrada por su asociacion con paciente");
      return res.status(404).json({ error: "OrdenRadiografias no encontrada" });
    }
    logger.info("OrdenRadiografias obtenidas correctamente por su asociacion con el paciente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el OrdenRadiografia mediante por paciente: " + error.message);
    res.status(500).json({ error: "Error al obtener OrdenRadiografias" });
  }
};

// Obtener una OrdenRadiografia por ID
exports.getOrdenRadiografiaById = async (req, res) => {
  try {
    const dato = await OrdenRadiografia.findByPk(req.params.id);
    if (!dato) {
      logger.error("OrdenRadiografia no encontrada por su ID");
      return res.status(404).json({ error: "OrdenRadiografia no encontrada" });
    }
    logger.info("OrdenRadiografia obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el OrdenRadiografia mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener OrdenRadiografia" });
  }
};

// Crear una OrdenRadiografia
exports.createOrdenRadiografia = async (req, res) => {
  try {
    const dato = await OrdenRadiografia.create(req.body);
    logger.info("OrdenRadiografias creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un OrdenRadiografia: " + error.message);
    res.status(500).json({ error: "Error al crear OrdenRadiografia" });
  }
};

// Actualizar una OrdenRadiografia
exports.updateOrdenRadiografia = async (req, res) => {
  try {
    const dato = await OrdenRadiografia.findByPk(req.params.id);
    if (!dato) {
      logger.error("OrdenRadiografia no encontrada por su ID");
      return res.status(404).json({ error: "OrdenRadiografia no encontrada" });
    }
    await dato.update(req.body);
    logger.info("OrdenRadiografia actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un OrdenRadiografia: " + error.message);
    res.status(500).json({ error: "Error al actualizar OrdenRadiografia" });
  }
};

// Eliminar una OrdenRadiografia
exports.deleteOrdenRadiografia = async (req, res) => {
  try {
    const dato = await OrdenRadiografia.findByPk(req.params.id);
    if (!dato) {
      logger.error("OrdenRadiografia no encontrada por su ID");
      return res.status(404).json({ error: "OrdenRadiografia no encontrada" });
    }
    await OrdenRadiografia.destroy();
    logger.info("OrdenRadiografia eliminado correctamente");
    res.json({ message: "OrdenRadiografia eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un OrdenRadiografia: " + error.message);
    res.status(500).json({ error: "Error al eliminar OrdenRadiografia" });
  }
};

