const {Patrimonio,SubCategoriaPatrimonio,CategoriaPatrimonio} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Patrimonioes
exports.getPatrimonioAll = async (req, res) => {
  try {
    const patrimonios = await Patrimonio.findAll(
      {
        include: [
          {
            model: SubCategoriaPatrimonio,
            as: 'subcategoria',
            attributes: ['id', 'Nombre','CategoriaPatrimonioId'],
            include: [
              {
                model: CategoriaPatrimonio,
                as: 'categoria',
                attributes: ['id', 'Nombre']
              }
            ]
          }
        ],
        order: [['FechaAdquisicion', 'DESC']]
      }
    );
    logger.info("Patrimonios obtenidos correctamente");
    res.json(patrimonios);
  } catch (error) {
    logger.error("Error al obtener Patrimonios: " + error.message);
    res.status(500).json({ error: "Error al obtener Patrimonioes" });
  }
};

// Obtener todas las Patrimonioes
exports.getPatrimonioABySede = async (req, res) => {
  try {
    const { sede } = req.params; 
    const patrimonios = await Patrimonio.findAll(
      {
        where: {
          SedeId: sede
        },
        include: [
          {
            model: SubCategoriaPatrimonio,
            as: 'subcategoria',
            attributes: ['id', 'Nombre','CategoriaPatrimonioId'],
            include: [
              {
                model: CategoriaPatrimonio,
                as: 'categoria',
                attributes: ['id', 'Nombre']
              }
            ]
          }
        ],
        order: [['FechaAdquisicion', 'DESC']]
      }
    );
    logger.info("Patrimonios obtenidos correctamente");
    res.json(patrimonios);
  } catch (error) {
    logger.error("Error al obtener Patrimonios: " + error.message);
    res.status(500).json({ error: "Error al obtener Patrimonioes" });
  }
};

// Obtener todas las Patrimonioes
exports.getPatrimonioABySubCategoria = async (req, res) => {
  try {
    const { subcategoria, sede } = req.params; 
    const patrimonios = await Patrimonio.findAll(
      {
        where: {
          SubCategoriaPatrimonioId: subcategoria,
          SedeId: sede
        },
        include: [
          {
            model: SubCategoriaPatrimonio,
            as: 'subcategoria',
            attributes: ['id', 'Nombre','CategoriaPatrimonioId'],
            include: [
              {
                model: CategoriaPatrimonio,
                as: 'categoria',
                attributes: ['id', 'Nombre']
              }
            ]
          }
        ],
        order: [['FechaAdquisicion', 'DESC']]
      }
    );
    logger.info("Patrimonios obtenidos correctamente");
    res.json(patrimonios);
  } catch (error) {
    logger.error("Error al obtener Patrimonios: " + error.message);
    res.status(500).json({ error: "Error al obtener Patrimonioes" });
  }
};

// Obtener todas las Patrimonioes
exports.getPatrimonioAByEstado = async (req, res) => {
  try {
    const { estado } = req.params; 
    const patrimonios = await Patrimonio.findAll(
      {
        where: {
          Estado: estado,
          SedeId: sede
        },
        include: [
          {
            model: SubCategoriaPatrimonio,
            as: 'subcategoria',
            attributes: ['id', 'Nombre','CategoriaPatrimonioId'],
            include: [
              {
                model: CategoriaPatrimonio,
                as: 'categoria',
                attributes: ['id', 'Nombre']
              }
            ]
          }
        ],
        order: [['FechaAdquisicion', 'DESC']]
      }
    );
    logger.info("Patrimonios obtenidos correctamente");
    res.json(patrimonios);
  } catch (error) {
    logger.error("Error al obtener Patrimonios: " + error.message);
    res.status(500).json({ error: "Error al obtener Patrimonioes" });
  }
};

// Obtener todas las Patrimonioes
exports.getPatrimonioAByResponsable = async (req, res) => {
  try {
    const { resposable } = req.params; 
    const patrimonios = await Patrimonio.findAll(
      {
        where: {
          Responsable: resposable,
          SedeId: sede
        },
        include: [
          {
            model: SubCategoriaPatrimonio,
            as: 'subcategoria',
            attributes: ['id', 'Nombre','CategoriaPatrimonioId'],
            include: [
              {
                model: CategoriaPatrimonio,
                as: 'categoria',
                attributes: ['id', 'Nombre']
              }
            ]
          }
        ],
        order: [['FechaAdquisicion', 'DESC']]
      }
    );
    logger.info("Patrimonios obtenidos correctamente");
    res.json(patrimonios);
  } catch (error) {
    logger.error("Error al obtener Patrimonios: " + error.message);
    res.status(500).json({ error: "Error al obtener Patrimonioes" });
  }
};

// Obtener todas las Patrimonioes
exports.getPatrimonioAByCodigo = async (req, res) => {
  try {
    const { codigo } = req.params; 
    const patrimonio = await Patrimonio.findAll(
      {
        where: {
          Codigo: codigo
        },
        include: [
          {
            model: SubCategoriaPatrimonio,
            as: 'subcategoria',
            attributes: ['id', 'Nombre','CategoriaPatrimonioId'],
            include: [
              {
                model: CategoriaPatrimonio,
                as: 'categoria',
                attributes: ['id', 'Nombre']
              }
            ]
          }
        ],
        order: [['FechaAdquisicion', 'DESC']]
      }
    );
    logger.info("Patrimonios obtenidos correctamente");
    res.json(patrimonio[0]);
  } catch (error) {
    logger.error("Error al obtener Patrimonios: " + error.message);
    res.status(500).json({ error: "Error al obtener Patrimonioes" });
  }
};

// Obtener una Patrimonio por ID
exports.getPatrimonioById = async (req, res) => {
  try {
    const patrimonio = await Patrimonio.findByPk(
      req.params.id,
      {
        include: [
          {
            model: SubCategoriaPatrimonio,
            as: 'subcategoria',
            attributes: ['id', 'Nombre','CategoriaPatrimonioId'],
            include: [
              {
                model: CategoriaPatrimonio,
                as: 'categoria',
                attributes: ['id', 'Nombre']
              }
            ]
          }
        ],
        order: [['FechaAdquisicion', 'DESC']]
      }
    );
    if (!patrimonio) {
      logger.error("Patrimonio no encontrada por su ID");
      return res.status(404).json({ error: "Patrimonio no encontrada" });
    }
    logger.info("Patrimonio obtenido correctamente por su ID");
    res.json(patrimonio);
  } catch (error) {
    logger.error("Error al obtener el Patrimonio mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Patrimonio" });
  }
};

// Crear una Patrimonio
exports.createPatrimonio = async (req, res) => {
  try {
    const patrimonio = await Patrimonio.create(req.body);
    logger.info("Patrimonios creado correctamente");
    res.status(201).json(patrimonio);
  } catch (error) {
    logger.error("Error al crear un Patrimonio: " + error.message);
    res.status(500).json({ error: "Error al crear Patrimonio" });
  }
};

// Actualizar una Patrimonio
exports.updatePatrimonio = async (req, res) => {
  try {
    const patrimonio = await Patrimonio.findByPk(req.params.id);
    if (!patrimonio) {
      logger.error("Patrimonio no encontrada por su ID");
      return res.status(404).json({ error: "Patrimonio no encontrada" });
    }
    await patrimonio.update(req.body);
    logger.info("Patrimonios actualizado correctamente");
    res.json(patrimonio);
  } catch (error) {
    logger.error("Error al actualizar un Patrimonio: " + error.message);
    res.status(500).json({ error: "Error al actualizar Patrimonio" });
  }
};

// Eliminar una Patrimonio
exports.deletePatrimonio = async (req, res) => {
  try {
    const patrimonio = await Patrimonio.findByPk(req.params.id);
    if (!patrimonio) {
      logger.error("Patrimonio no encontrada por su ID");
      return res.status(404).json({ error: "Patrimonio no encontrada" });
    }
    await Patrimonio.destroy();
    logger.info("Patrimonios eliminado correctamente");
    res.json({ message: "Patrimonio eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Patrimonio: " + error.message);
    res.status(500).json({ error: "Error al eliminar Patrimonio" });
  }
};

