const {Periodo} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Periodoes
exports.getPeriodoAll = async (req, res) => {
  try {
    const periodos = await Periodo.findAll();
    logger.info("Periodos obtenidos correctamente");
    res.json(periodos);
  } catch (error) {
    logger.error("Error al obtener Periodos: " + error.message);
    res.status(500).json({ error: "Error al obtener Periodoes" });
  }
};

// Obtener una Periodo por ID
exports.getPeriodoById = async (req, res) => {
  try {
    const periodo = await Periodo.findByPk(req.params.id);
    if (!periodo) {
      logger.error("Periodo no encontrada por su ID");
      return res.status(404).json({ error: "Periodo no encontrada" });
    }
    logger.info("Periodo obtenido correctamente por su ID");
    res.json(periodo);
  } catch (error) {
    logger.error("Error al obtener el Periodo mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Periodo" });
  }
};

// Crear una Periodo
exports.createPeriodo = async (req, res) => {
  try {
    const periodo = await Periodo.create(req.body);
    logger.info("Periodos creado correctamente");
    res.status(201).json(periodo);
  } catch (error) {
    logger.error("Error al crear un Periodo: " + error.message);
    res.status(500).json({ error: "Error al crear Periodo" });
  }
};

// Actualizar una Periodo
exports.updatePeriodo = async (req, res) => {
  try {
    const periodo = await Periodo.findByPk(req.params.id);
    if (!periodo) {
      logger.error("Periodo no encontrada por su ID");
      return res.status(404).json({ error: "Periodo no encontrada" });
    }
    await periodo.update(req.body);
    logger.info("Periodos actualizado correctamente");
    res.json(periodo);
  } catch (error) {
    logger.error("Error al actualizar un Periodo: " + error.message);
    res.status(500).json({ error: "Error al actualizar Periodo" });
  }
};

// Eliminar una Periodo
exports.deletePeriodo = async (req, res) => {
  try {
    const periodo = await Periodo.findByPk(req.params.id);
    if (!periodo) {
      logger.error("Periodo no encontrada por su ID");
      return res.status(404).json({ error: "Periodo no encontrada" });
    }
    await Periodo.destroy();
    logger.info("Periodos eliminado correctamente");
    res.json({ message: "Periodo eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Periodo: " + error.message);
    res.status(500).json({ error: "Error al eliminar Periodo" });
  }
};

