const {PeticionLaboratorio} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las PeticionLaboratorioes
exports.getPeticionLaboratorioAll = async (req, res) => {
  try {
    const datos = await PeticionLaboratorio.findAll();
    logger.info("PeticionLaboratorios obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener PeticionLaboratorios: " + error.message);
    res.status(500).json({ error: "Error al obtener PeticionLaboratorioes" });
  }
};
// Obtener una PeticionLaboratorio por item
exports.getPeticionLaboratorioByItemLaboratorio = async (req, res) => {
  try {
    const { item } = req.params;
    const datos = await PeticionLaboratorio.findAll(
      {
        where: {
          ItemLaboratorioId: item
        }
      }
    );
    if (!datos) {
      logger.error("PeticionLaboratorio no encontrada por su asociacion con paciente");
      return res.status(404).json({ error: "PeticionLaboratorios no encontrada" });
    }
    logger.info("PeticionLaboratorios obtenidas correctamente por su asociacion con el paciente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el PeticionLaboratorio mediante por paciente: " + error.message);
    res.status(500).json({ error: "Error al obtener PeticionLaboratorios" });
  }
};

// Obtener una PeticionLaboratorio por Empresa
exports.getPeticionLaboratorioByOrdenLaboratorio = async (req, res) => {
  try {
    const { orden } = req.params;
    const datos = await PeticionLaboratorio.findAll(
      {
        where: {
          OrdenLaboratorioId: orden
        }
      }
    );
    if (!datos) {
      logger.error("PeticionLaboratorio no encontrada por su asociacion con paciente");
      return res.status(404).json({ error: "PeticionLaboratorios no encontrada" });
    }
    logger.info("PeticionLaboratorios obtenidas correctamente por su asociacion con el paciente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el PeticionLaboratorio mediante por paciente: " + error.message);
    res.status(500).json({ error: "Error al obtener PeticionLaboratorios" });
  }
};

// Obtener una PeticionLaboratorio por Empresa
exports.getPeticionLaboratorioByOrdeneItem = async (req, res) => {
  try {
    const { orden, item } = req.params;
    const dato = await PeticionLaboratorio.findOne(
      {
        where: {
          OrdenLaboratorioId: orden,
          ItemLaboratorioId: item
        }
      }
    );
    if (!dato) {
      logger.error("PeticionLaboratorio no encontrada por su asociacion con paciente");
      return res.status(404).json({ error: "PeticionLaboratorios no encontrada" });
    }
    logger.info("PeticionLaboratorios obtenidas correctamente por su asociacion con el paciente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el PeticionLaboratorio mediante por paciente: " + error.message);
    res.status(500).json({ error: "Error al obtener PeticionLaboratorios" });
  }
};

// Obtener una PeticionLaboratorio por ID
exports.getPeticionLaboratorioById = async (req, res) => {
  try {
    const dato = await PeticionLaboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("PeticionLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "PeticionLaboratorio no encontrada" });
    }
    logger.info("PeticionLaboratorio obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el PeticionLaboratorio mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener PeticionLaboratorio" });
  }
};

// Crear una PeticionLaboratorio
exports.createPeticionLaboratorio = async (req, res) => {
  try {
    const dato = await PeticionLaboratorio.create(req.body);
    logger.info("PeticionLaboratorios creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un PeticionLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al crear PeticionLaboratorio" });
  }
};

// Actualizar una PeticionLaboratorio
exports.updatePeticionLaboratorio = async (req, res) => {
  try {
    const dato = await PeticionLaboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("PeticionLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "PeticionLaboratorio no encontrada" });
    }
    await dato.update(req.body);
    logger.info("PeticionLaboratorio actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un PeticionLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al actualizar PeticionLaboratorio" });
  }
};

// Eliminar una PeticionLaboratorio
exports.deletePeticionLaboratorio = async (req, res) => {
  try {
    const dato = await PeticionLaboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("PeticionLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "PeticionLaboratorio no encontrada" });
    }
    await dato.destroy();
    logger.info("PeticionLaboratorio eliminado correctamente");
    res.json({ message: "PeticionLaboratorio eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un PeticionLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al eliminar PeticionLaboratorio" });
  }
};

