const {PeticionRadiografia} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las PeticionRadiografiaes
exports.getPeticionRadiografiaAll = async (req, res) => {
  try {
    const datos = await PeticionRadiografia.findAll();
    logger.info("PeticionRadiografias obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener PeticionRadiografias: " + error.message);
    res.status(500).json({ error: "Error al obtener PeticionRadiografiaes" });
  }
};
// Obtener una PeticionRadiografia por Orden Radiografia
exports.getPeticionRadiografiaByOrdenRadiografia = async (req, res) => {
  try {
    const { orden } = req.params;
    const datos = await PeticionRadiografia.findAll(
      {
        where: {
          OrdenRadiografiaId: orden
        }
      }
    );
    if (!datos) {
      logger.error("PeticionRadiografia no encontrada por su asociacion con paciente");
      return res.status(404).json({ error: "PeticionRadiografias no encontrada" });
    }
    logger.info("PeticionRadiografias obtenidas correctamente por su asociacion con el paciente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el PeticionRadiografia mediante por paciente: " + error.message);
    res.status(500).json({ error: "Error al obtener PeticionRadiografias" });
  }
};

// Obtener una PeticionRadiografia por Item Radiografia
exports.getPeticionRadiografiaByItemRadiografia = async (req, res) => {
  try {
    const { item } = req.params;
    const datos = await PeticionRadiografia.findAll(
      {
        where: {
          ItemRadiografiaId: item
        }
      }
    );
    if (!datos) {
      logger.error("PeticionRadiografia no encontrada por su asociacion con paciente");
      return res.status(404).json({ error: "PeticionRadiografias no encontrada" });
    }
    logger.info("PeticionRadiografias obtenidas correctamente por su asociacion con el paciente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el PeticionRadiografia mediante por paciente: " + error.message);
    res.status(500).json({ error: "Error al obtener PeticionRadiografias" });
  }
};

// Obtener una PeticionRadiografia por ID
exports.getPeticionRadiografiaById = async (req, res) => {
  try {
    const dato = await PeticionRadiografia.findByPk(req.params.id);
    if (!dato) {
      logger.error("PeticionRadiografia no encontrada por su ID");
      return res.status(404).json({ error: "PeticionRadiografia no encontrada" });
    }
    logger.info("PeticionRadiografia obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el PeticionRadiografia mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener PeticionRadiografia" });
  }
};

// Crear una PeticionRadiografia
exports.createPeticionRadiografia = async (req, res) => {
  try {
    const dato = await PeticionRadiografia.create(req.body);
    logger.info("PeticionRadiografias creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un PeticionRadiografia: " + error.message);
    res.status(500).json({ error: "Error al crear PeticionRadiografia" });
  }
};

// Actualizar una PeticionRadiografia
exports.updatePeticionRadiografia = async (req, res) => {
  try {
    const dato = await PeticionRadiografia.findByPk(req.params.id);
    if (!dato) {
      logger.error("PeticionRadiografia no encontrada por su ID");
      return res.status(404).json({ error: "PeticionRadiografia no encontrada" });
    }
    await dato.update(req.body);
    logger.info("PeticionRadiografia actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un PeticionRadiografia: " + error.message);
    res.status(500).json({ error: "Error al actualizar PeticionRadiografia" });
  }
};

// Eliminar una PeticionRadiografia
exports.deletePeticionRadiografia = async (req, res) => {
  try {
    const dato = await PeticionRadiografia.findByPk(req.params.id);
    if (!dato) {
      logger.error("PeticionRadiografia no encontrada por su ID");
      return res.status(404).json({ error: "PeticionRadiografia no encontrada" });
    }
    await dato.destroy();
    logger.info("PeticionRadiografia eliminado correctamente");
    res.json({ message: "PeticionRadiografia eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un PeticionRadiografia: " + error.message);
    res.status(500).json({ error: "Error al eliminar PeticionRadiografia" });
  }
};

