const {PlanTratamiento} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las PlanTratamientoes
exports.getPlanTratamientoAll = async (req, res) => {
  try {
    const datos = await PlanTratamiento.findAll();
    logger.info("PlanTratamientos obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener PlanTratamientos: " + error.message);
    res.status(500).json({ error: "Error al obtener PlanTratamientoes" });
  }
};

// Obtener PlanTratamiento por Historia Clinica
exports.getPlanTratamientoByPaciente = async (req, res) => {
  try {
    const { paciente } = req.params;
    const datos = await PlanTratamiento.findAll(
      {
        where: {
          PacienteId: paciente
        }
      }
    );
    if (!datos) {
      logger.error("PlanTratamiento no encontrada por su asociacion con Historia Clinica");
      return res.status(404).json({ error: "PlanTratamientos no encontrada" });
    }
    logger.info("PlanTratamientos obtenidas correctamente por su asociacion con la Historia Clinica");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el PlanTratamiento mediante por Historia Clinica: " + error.message);
    res.status(500).json({ error: "Error al obtener PlanTratamientos" });
  }
};

// Obtener una PlanTratamiento por ID
exports.getPlanTratamientoById = async (req, res) => {
  try {
    const dato = await PlanTratamiento.findByPk(req.params.id);
    if (!dato) {
      logger.error("PlanTratamiento no encontrada por su ID");
      return res.status(404).json({ error: "PlanTratamiento no encontrada" });
    }
    logger.info("PlanTratamiento obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el PlanTratamiento mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener PlanTratamiento" });
  }
};

// Crear una PlanTratamiento
exports.createPlanTratamiento = async (req, res) => {
  try {
    const dato = await PlanTratamiento.create(req.body);
    logger.info("PlanTratamientos creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un PlanTratamiento: " + error.message);
    res.status(500).json({ error: "Error al crear PlanTratamiento" });
  }
};

// Actualizar una PlanTratamiento
exports.updatePlanTratamiento = async (req, res) => {
  try {
    const dato = await PlanTratamiento.findByPk(req.params.id);
    if (!dato) {
      logger.error("PlanTratamiento no encontrada por su ID");
      return res.status(404).json({ error: "PlanTratamiento no encontrada" });
    }
    await dato.update(req.body);
    logger.info("PlanTratamientos actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un PlanTratamiento: " + error.message);
    res.status(500).json({ error: "Error al actualizar PlanTratamiento" });
  }
};

// Eliminar una PlanTratamiento
exports.deletePlanTratamiento = async (req, res) => {
  try {
    const dato = await PlanTratamiento.findByPk(req.params.id);
    if (!dato) {
      logger.error("PlanTratamiento no encontrada por su ID");
      return res.status(404).json({ error: "PlanTratamiento no encontrada" });
    }
    await PlanTratamiento.destroy();
    logger.info("PlanTratamientos eliminado correctamente");
    res.json({ message: "PlanTratamiento eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un PlanTratamiento: " + error.message);
    res.status(500).json({ error: "Error al eliminar PlanTratamiento" });
  }
};

