const {PresupuestoParcial} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las PresupuestoParciales
exports.getPresupuestoParcialAll = async (req, res) => {
  try {
    const presupuestos = await PresupuestoParcial.findAll();
    logger.info("PresupuestoParcials obtenidos correctamente");
    res.json(presupuestos);
  } catch (error) {
    logger.error("Error al obtener PresupuestoParcials: " + error.message);
    res.status(500).json({ error: "Error al obtener PresupuestoParciales" });
  }
};

// Filtrar PresupuestoParciales por odontologoId
exports.getPresupuestoParcialByHistoria = async (req, res) => {
  try {
    const { historia } = req.params;
    const presupuestos = await PresupuestoParcial.findAll(
      {
        where: {
          PacienteId: historia
        }
      }
    );

    res.json(presupuestos);
  } catch (error) {
    res.status(500).json({ error: "Error al filtrar PresupuestoParciales por odontólogo" });
  }
};

// Obtener una PresupuestoParcial por ID
exports.getPresupuestoParcialById = async (req, res) => {
  try {
    const presupuesto = await PresupuestoParcial.findByPk(req.params.id);
    if (!presupuesto) {
      logger.error("PresupuestoParcial no encontrada por su ID");
      return res.status(404).json({ error: "PresupuestoParcial no encontrada" });
    }
    logger.info("PresupuestoParcial obtenido correctamente por su ID");
    res.json(presupuesto);
  } catch (error) {
    logger.error("Error al obtener el PresupuestoParcial mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener PresupuestoParcial" });
  }
};

// Crear una PresupuestoParcial
exports.createPresupuestoParcial = async (req, res) => {
  try {
    const presupuesto = await PresupuestoParcial.create(req.body);
    logger.info("PresupuestoParcials creado correctamente");
    res.status(201).json(presupuesto);
  } catch (error) {
    logger.error("Error al crear un PresupuestoParcial: " + error.message);
    res.status(500).json({ error: "Error al crear PresupuestoParcial" });
  }
};

// Actualizar una PresupuestoParcial
exports.updatePresupuestoParcial = async (req, res) => {
  try {
    const presupuesto = await PresupuestoParcial.findByPk(req.params.id);
    if (!presupuesto) {
      logger.error("PresupuestoParcial no encontrada por su ID");
      return res.status(404).json({ error: "PresupuestoParcial no encontrada" });
    }
    await presupuesto.update(req.body);
    logger.info("PresupuestoParcials actualizado correctamente");
    res.json(presupuesto);
  } catch (error) {
    logger.error("Error al actualizar un PresupuestoParcial: " + error.message);
    res.status(500).json({ error: "Error al actualizar PresupuestoParcial" });
  }
};

// Eliminar una PresupuestoParcial
exports.deletePresupuestoParcial = async (req, res) => {
  try {
    const presupuesto = await PresupuestoParcial.findByPk(req.params.id);
    if (!presupuesto) {
      logger.error("PresupuestoParcial no encontrada por su ID");
      return res.status(404).json({ error: "PresupuestoParcial no encontrada" });
    }
    await PresupuestoParcial.destroy();
    logger.info("PresupuestoParcials eliminado correctamente");
    res.json({ message: "PresupuestoParcial eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un PresupuestoParcial: " + error.message);
    res.status(500).json({ error: "Error al eliminar PresupuestoParcial" });
  }
};
