const {PresupuestoTotal} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las PresupuestoTotales
exports.getPresupuestoTotalAll = async (req, res) => {
  try {
    const presupuestos = await PresupuestoTotal.findAll();
    logger.info("PresupuestoTotals obtenidos correctamente");
    res.json(presupuestos);
  } catch (error) {
    logger.error("Error al obtener PresupuestoTotals: " + error.message);
    res.status(500).json({ error: "Error al obtener PresupuestoTotales" });
  }
};

// Filtrar PresupuestoTotales por odontologoId
exports.getPresupuestoTotalByHistoria = async (req, res) => {
  try {
    const { historia } = req.params;
    const presupuestos = await PresupuestoTotal.findAll(
      {
        where: {
          PacienteId: historia
        }
      }
    );

    res.json(presupuestos);
  } catch (error) {
    res.status(500).json({ error: "Error al filtrar PresupuestoTotales por odontólogo" });
  }
};

// Obtener una PresupuestoTotal por ID
exports.getPresupuestoTotalById = async (req, res) => {
  try {
    const presupuesto = await PresupuestoTotal.findByPk(req.params.id);
    if (!presupuesto) {
      logger.error("PresupuestoTotal no encontrada por su ID");
      return res.status(404).json({ error: "PresupuestoTotal no encontrada" });
    }
    logger.info("PresupuestoTotal obtenido correctamente por su ID");
    res.json(presupuesto);
  } catch (error) {
    logger.error("Error al obtener el PresupuestoTotal mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener PresupuestoTotal" });
  }
};

// Crear una PresupuestoTotal
exports.createPresupuestoTotal = async (req, res) => {
  try {
    const presupuesto = await PresupuestoTotal.create(req.body);
    logger.info("PresupuestoTotals creado correctamente");
    res.status(201).json(presupuesto);
  } catch (error) {
    logger.error("Error al crear un PresupuestoTotal: " + error.message);
    res.status(500).json({ error: "Error al crear PresupuestoTotal" });
  }
};

// Actualizar una PresupuestoTotal
exports.updatePresupuestoTotal = async (req, res) => {
  try {
    const presupuesto = await PresupuestoTotal.findByPk(req.params.id);
    if (!presupuesto) {
      logger.error("PresupuestoTotal no encontrada por su ID");
      return res.status(404).json({ error: "PresupuestoTotal no encontrada" });
    }
    await presupuesto.update(req.body);
    logger.info("PresupuestoTotals actualizado correctamente");
    res.json(presupuesto);
  } catch (error) {
    logger.error("Error al actualizar un PresupuestoTotal: " + error.message);
    res.status(500).json({ error: "Error al actualizar PresupuestoTotal" });
  }
};

// Eliminar una PresupuestoTotal
exports.deletePresupuestoTotal = async (req, res) => {
  try {
    const presupuesto = await PresupuestoTotal.findByPk(req.params.id);
    if (!presupuesto) {
      logger.error("PresupuestoTotal no encontrada por su ID");
      return res.status(404).json({ error: "PresupuestoTotal no encontrada" });
    }
    await PresupuestoTotal.destroy();
    logger.info("PresupuestoTotals eliminado correctamente");
    res.json({ message: "PresupuestoTotal eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un PresupuestoTotal: " + error.message);
    res.status(500).json({ error: "Error al eliminar PresupuestoTotal" });
  }
};
