const {Procedimiento} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las procedimientoes
exports.getProcedimientoAll = async (req, res) => {
  try {
    const procedimientos = await Procedimiento.findAll();
    logger.info("procedimientos obtenidos correctamente");
    res.json(procedimientos);
  } catch (error) {
    logger.error("Error al obtener procedimientos: " + error.message);
    res.status(500).json({ error: "Error al obtener procedimientoes" });
  }
};

// Obtener una procedimiento por ID
exports.getProcedimientoById = async (req, res) => {
  try {
    const procedimiento = await Procedimiento.findByPk(req.params.id);
    if (!procedimiento) {
      logger.error("procedimiento no encontrada por su ID");
      return res.status(404).json({ error: "procedimiento no encontrada" });
    }
    logger.info("procedimiento obtenido correctamente por su ID");
    res.json(procedimiento);
  } catch (error) {
    logger.error("Error al obtener el procedimiento mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener procedimiento" });
  }
};

// Crear una procedimiento
exports.createProcedimiento = async (req, res) => {
  try {
    const procedimiento = await Procedimiento.create(req.body);
    logger.info("procedimientos creado correctamente");
    res.status(201).json(procedimiento);
  } catch (error) {
    logger.error("Error al crear un procedimiento: " + error.message);
    res.status(500).json({ error: "Error al crear procedimiento" });
  }
};

// Actualizar una procedimiento
exports.updateProcedimiento = async (req, res) => {
  try {
    const procedimiento = await Procedimiento.findByPk(req.params.id);
    if (!procedimiento) {
      logger.error("procedimiento no encontrada por su ID");
      return res.status(404).json({ error: "procedimiento no encontrada" });
    }
    await procedimiento.update(req.body);
    logger.info("procedimiento actualizado correctamente");
    res.json(procedimiento);
  } catch (error) {
    logger.error("Error al actualizar un procedimiento: " + error.message);
    res.status(500).json({ error: "Error al actualizar procedimiento" });
  }
};

// Eliminar una procedimiento
exports.deleteProcedimiento = async (req, res) => {
  try {
    const procedimiento = await Procedimiento.findByPk(req.params.id);
    if (!procedimiento) {
      logger.error("procedimiento no encontrada por su ID");
      return res.status(404).json({ error: "procedimiento no encontrada" });
    }
    await procedimiento.destroy();
    logger.info("procedimiento eliminado correctamente");
    res.json({ message: "procedimiento eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un procedimiento: " + error.message);
    res.status(500).json({ error: "Error al eliminar procedimiento" });
  }
};

