const {Profesion} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Profesiones
exports.getProfesionAll = async (req, res) => {
  try {
    const profesiones = await Profesion.findAll();
    logger.info("Profesions obtenidos correctamente");
    res.json(profesiones);
  } catch (error) {
    logger.error("Error al obtener Profesions: " + error.message);
    res.status(500).json({ error: "Error al obtener Profesiones" });
  }
};

// Obtener una Profesion por ID
exports.getProfesionById = async (req, res) => {
  try {
    const profesion = await Profesion.findByPk(req.params.id);
    if (!profesion) {
      logger.error("Profesion no encontrada por su ID");
      return res.status(404).json({ error: "Profesion no encontrada" });
    }
    logger.info("Profesion obtenido correctamente por su ID");
    res.json(profesion);
  } catch (error) {
    logger.error("Error al obtener el Profesion mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Profesion" });
  }
};

// Crear una Profesion
exports.createProfesion = async (req, res) => {
  try {
    const profesion = await Profesion.create(req.body);
    logger.info("Profesions creado correctamente");
    res.status(201).json(profesion);
  } catch (error) {
    logger.error("Error al crear un Profesion: " + error.message);
    res.status(500).json({ error: "Error al crear Profesion" });
  }
};

// Actualizar una Profesion
exports.updateProfesion = async (req, res) => {
  try {
    const profesion = await Profesion.findByPk(req.params.id);
    if (!profesion) {
      logger.error("Profesion no encontrada por su ID");
      return res.status(404).json({ error: "Profesion no encontrada" });
    }
    await profesion.update(req.body);
    logger.info("Profesions actualizado correctamente");
    res.json(profesion);
  } catch (error) {
    logger.error("Error al actualizar un Profesion: " + error.message);
    res.status(500).json({ error: "Error al actualizar Profesion" });
  }
};

// Eliminar una Profesion
exports.deleteProfesion = async (req, res) => {
  try {
    const profesion = await Profesion.findByPk(req.params.id);
    if (!profesion) {
      logger.error("Profesion no encontrada por su ID");
      return res.status(404).json({ error: "Profesion no encontrada" });
    }
    await Profesion.destroy();
    logger.info("Profesions eliminado correctamente");
    res.json({ message: "Profesion eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Profesion: " + error.message);
    res.status(500).json({ error: "Error al eliminar Profesion" });
  }
};

