const {Radiografia} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Radiografiaes
exports.getRadiografiaAll = async (req, res) => {
  try {
    const datos = await Radiografia.findAll();
    logger.info("Radiografias obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener Radiografias: " + error.message);
    res.status(500).json({ error: "Error al obtener Radiografiaes" });
  }
};
// Obtener una Radiografia por ID
exports.getRadiografiaById = async (req, res) => {
  try {
    const dato = await Radiografia.findByPk(req.params.id);
    if (!dato) {
      logger.error("Radiografia no encontrada por su ID");
      return res.status(404).json({ error: "Radiografia no encontrada" });
    }
    logger.info("Radiografia obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el Radiografia mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Radiografia" });
  }
};

// Crear una Radiografia
exports.createRadiografia = async (req, res) => {
  try {
    const dato = await Radiografia.create(req.body);
    logger.info("Radiografias creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un Radiografia: " + error.message);
    res.status(500).json({ error: "Error al crear Radiografia" });
  }
};

// Actualizar una Radiografia
exports.updateRadiografia = async (req, res) => {
  try {
    const dato = await Radiografia.findByPk(req.params.id);
    if (!dato) {
      logger.error("Radiografia no encontrada por su ID");
      return res.status(404).json({ error: "Radiografia no encontrada" });
    }
    await dato.update(req.body);
    logger.info("Radiografias actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un Radiografia: " + error.message);
    res.status(500).json({ error: "Error al actualizar Radiografia" });
  }
};

// Eliminar una Radiografia
exports.deleteRadiografia = async (req, res) => {
  try {
    const dato = await Radiografia.findByPk(req.params.id);
    if (!dato) {
      logger.error("Radiografia no encontrada por su ID");
      return res.status(404).json({ error: "Radiografia no encontrada" });
    }
    await Radiografia.destroy();
    logger.info("Radiografias eliminado correctamente");
    res.json({ message: "Radiografia eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Radiografia: " + error.message);
    res.status(500).json({ error: "Error al eliminar Radiografia" });
  }
};

