const {Relacion} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Relaciones
exports.getRelacionAll = async (req, res) => {
  try {
    const relaciones = await Relacion.findAll();
    logger.info("Relacions obtenidos correctamente");
    res.json(relaciones);
  } catch (error) {
    logger.error("Error al obtener Relacions: " + error.message);
    res.status(500).json({ error: "Error al obtener Relaciones" });
  }
};

// Obtener una Relacion por ID
exports.getRelacionById = async (req, res) => {
  try {
    const relacion = await Relacion.findByPk(req.params.id);
    if (!relacion) {
      logger.error("Relacion no encontrada por su ID");
      return res.status(404).json({ error: "Relacion no encontrada" });
    }
    logger.info("Relacion obtenido correctamente por su ID");
    res.json(relacion);
  } catch (error) {
    logger.error("Error al obtener el Relacion mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Relacion" });
  }
};

// Crear una Relacion
exports.createRelacion = async (req, res) => {
  try {
    const relacion = await Relacion.create(req.body);
    logger.info("Relacion creado correctamente");
    res.status(201).json(relacion);
  } catch (error) {
    logger.error("Error al crear un Relacion: " + error.message);
    res.status(500).json({ error: "Error al crear Relacion" });
  }
};

// Actualizar una Relacion
exports.updateRelacion = async (req, res) => {
  try {
    const relacion = await Relacion.findByPk(req.params.id);
    if (!relacion) {
      logger.error("Relacion no encontrada por su ID");
      return res.status(404).json({ error: "Relacion no encontrada" });
    }
    await relacion.update(req.body);
    logger.info("Relacion actualizado correctamente");
    res.json(relacion);
  } catch (error) {
    logger.error("Error al actualizar un Relacion: " + error.message);
    res.status(500).json({ error: "Error al actualizar Relacion" });
  }
};

// Eliminar una Relacion
exports.deleteRelacion = async (req, res) => {
  try {
    const relacion = await Relacion.findByPk(req.params.id);
    if (!relacion) {
      logger.error("Relacion no encontrada por su ID");
      return res.status(404).json({ error: "Relacion no encontrada" });
    }
    await Relacion.destroy();
    logger.info("Relacion eliminado correctamente");
    res.json({ message: "Relacion eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Relacion: " + error.message);
    res.status(500).json({ error: "Error al eliminar Relacion" });
  }
};

