const {ResultadoLaboratorio} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las ResultadoLaboratorioes
exports.getResultadoLaboratorioAll = async (req, res) => {
  try {
    const datos = await ResultadoLaboratorio.findAll();
    logger.info("ResultadoLaboratorios obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener ResultadoLaboratorios: " + error.message);
    res.status(500).json({ error: "Error al obtener ResultadoLaboratorioes" });
  }
};
// Obtener una ResultadoLaboratorio por Empresa
exports.getResultadoLaboratorioByEmpresa = async (req, res) => {
  try {
    const { empresa } = req.params;
    const datos = await ResultadoLaboratorio.findAll(
      {
        where: {
          EmpresaLaboratorioId: empresa
        }
      }
    );
    if (!datos) {
      logger.error("ResultadoLaboratorio no encontrada por su asociacion con paciente");
      return res.status(404).json({ error: "ResultadoLaboratorios no encontrada" });
    }
    logger.info("ResultadoLaboratorios obtenidas correctamente por su asociacion con el paciente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el ResultadoLaboratorio mediante por paciente: " + error.message);
    res.status(500).json({ error: "Error al obtener ResultadoLaboratorios" });
  }
};

// Obtener una ResultadoLaboratorio por Empresa
exports.getResultadoLaboratorioByOrden = async (req, res) => {
  try {
    const { orden } = req.params;
    const datos = await ResultadoLaboratorio.findOne(
      {
        where: {
          OrdenLaboratorioId: orden
        }
      }
    );
    if (!datos) {
      logger.error("ResultadoLaboratorio no encontrada por su asociacion con paciente");
      return res.status(404).json({ error: "ResultadoLaboratorios no encontrada" });
    }
    logger.info("ResultadoLaboratorios obtenidas correctamente por su asociacion con el paciente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el ResultadoLaboratorio mediante por paciente: " + error.message);
    res.status(500).json({ error: "Error al obtener ResultadoLaboratorios" });
  }
};

// Obtener una ResultadoLaboratorio por ID
exports.getResultadoLaboratorioById = async (req, res) => {
  try {
    const dato = await ResultadoLaboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("ResultadoLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "ResultadoLaboratorio no encontrada" });
    }
    logger.info("ResultadoLaboratorio obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el ResultadoLaboratorio mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener ResultadoLaboratorio" });
  }
};

// Crear una ResultadoLaboratorio
exports.createResultadoLaboratorio = async (req, res) => {
  try {
    const dato = await ResultadoLaboratorio.create(req.body);
    logger.info("ResultadoLaboratorios creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un ResultadoLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al crear ResultadoLaboratorio" });
  }
};

// Actualizar una ResultadoLaboratorio
exports.updateResultadoLaboratorio = async (req, res) => {
  try {
    const dato = await ResultadoLaboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("ResultadoLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "ResultadoLaboratorio no encontrada" });
    }
    await dato.update(req.body);
    logger.info("ResultadoLaboratorio actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un ResultadoLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al actualizar ResultadoLaboratorio" });
  }
};

// Eliminar una ResultadoLaboratorio
exports.deleteResultadoLaboratorio = async (req, res) => {
  try {
    const dato = await ResultadoLaboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("ResultadoLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "ResultadoLaboratorio no encontrada" });
    }
    await ResultadoLaboratorio.destroy();
    logger.info("ResultadoLaboratorio eliminado correctamente");
    res.json({ message: "ResultadoLaboratorio eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un ResultadoLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al eliminar ResultadoLaboratorio" });
  }
};

