const {ResultadoRadiografia} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las ResultadoRadiografiaes
exports.getResultadoRadiografiaAll = async (req, res) => {
  try {
    const datos = await ResultadoRadiografia.findAll();
    logger.info("ResultadoRadiografias obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener ResultadoRadiografias: " + error.message);
    res.status(500).json({ error: "Error al obtener ResultadoRadiografiaes" });
  }
};
// Obtener una ResultadoRadiografia por Orden Radiografia
exports.getResultadoRadiografiaByOrdenRadiografia = async (req, res) => {
  try {
    const { orden } = req.params;
    const datos = await ResultadoRadiografia.findOne(
      {
        where: {
          OrdenRadiografiaId: orden
        }
      }
    );
    if (!datos) {
      logger.error("ResultadoRadiografia no encontrada por su asociacion con paciente");
      return res.status(404).json({ error: "ResultadoRadiografias no encontrada" });
    }
    logger.info("ResultadoRadiografias obtenidas correctamente por su asociacion con el paciente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el ResultadoRadiografia mediante por paciente: " + error.message);
    res.status(500).json({ error: "Error al obtener ResultadoRadiografias" });
  }
};

// Obtener una ResultadoRadiografia por Empresa Radiografia
exports.getResultadoRadiografiaByEmpresaRadiografia = async (req, res) => {
  try {
    const { empresa } = req.params;
    const datos = await ResultadoRadiografia.findAll(
      {
        where: {
          EmpresaRadiografiaId: empresa
        }
      }
    );
    if (!datos) {
      logger.error("ResultadoRadiografia no encontrada por su asociacion con paciente");
      return res.status(404).json({ error: "ResultadoRadiografias no encontrada" });
    }
    logger.info("ResultadoRadiografias obtenidas correctamente por su asociacion con el paciente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el ResultadoRadiografia mediante por paciente: " + error.message);
    res.status(500).json({ error: "Error al obtener ResultadoRadiografias" });
  }
};

// Obtener una ResultadoRadiografia por ID
exports.getResultadoRadiografiaById = async (req, res) => {
  try {
    const dato = await ResultadoRadiografia.findByPk(req.params.id);
    if (!dato) {
      logger.error("ResultadoRadiografia no encontrada por su ID");
      return res.status(404).json({ error: "ResultadoRadiografia no encontrada" });
    }
    logger.info("ResultadoRadiografia obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el ResultadoRadiografia mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener ResultadoRadiografia" });
  }
};

// Crear una ResultadoRadiografia
exports.createResultadoRadiografia = async (req, res) => {
  try {
    const dato = await ResultadoRadiografia.create(req.body);
    logger.info("ResultadoRadiografias creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un ResultadoRadiografia: " + error.message);
    res.status(500).json({ error: "Error al crear ResultadoRadiografia" });
  }
};

// Actualizar una ResultadoRadiografia
exports.updateResultadoRadiografia = async (req, res) => {
  try {
    const dato = await ResultadoRadiografia.findByPk(req.params.id);
    if (!dato) {
      logger.error("ResultadoRadiografia no encontrada por su ID");
      return res.status(404).json({ error: "ResultadoRadiografia no encontrada" });
    }
    await dato.update(req.body);
    logger.info("ResultadoRadiografia actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un ResultadoRadiografia: " + error.message);
    res.status(500).json({ error: "Error al actualizar ResultadoRadiografia" });
  }
};

// Eliminar una ResultadoRadiografia
exports.deleteResultadoRadiografia = async (req, res) => {
  try {
    const dato = await ResultadoRadiografia.findByPk(req.params.id);
    if (!dato) {
      logger.error("ResultadoRadiografia no encontrada por su ID");
      return res.status(404).json({ error: "ResultadoRadiografia no encontrada" });
    }
    await ResultadoRadiografia.destroy();
    logger.info("ResultadoRadiografia eliminado correctamente");
    res.json({ message: "ResultadoRadiografia eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un ResultadoRadiografia: " + error.message);
    res.status(500).json({ error: "Error al eliminar ResultadoRadiografia" });
  }
};

