const {Sede} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Sedees
exports.getSedeAll = async (req, res) => {
  try {
    const sedes = await Sede.findAll();
    logger.info("Sedes obtenidos correctamente");
    res.json(sedes);
  } catch (error) {
    logger.error("Error al obtener Sedes: " + error.message);
    res.status(500).json({ error: "Error al obtener Sedees" });
  }
};
// Obtener una Sede por Empresa
exports.getSedeByEmpresa = async (req, res) => {
  try {
    const { empresa } = req.params;
    const sedes = await Sede.findAll(
      {
        where: {
          EmpresaId: empresa
        }
      }
    );
    if (!sedes) {
      logger.error("Sede no encontrada por su asociacion con empresa");
      return res.status(404).json({ error: "Sedes no encontrada" });
    }
    logger.info("Sedes obtenidas correctamente por su asociacion con la Empresa");
    res.json(sedes);
  } catch (error) {
    logger.error("Error al obtener el Sede mediante por Empresa: " + error.message);
    res.status(500).json({ error: "Error al obtener Sedes" });
  }
};

// Obtener una Sede por ID
exports.getSedeById = async (req, res) => {
  try {
    const sede = await Sede.findByPk(req.params.id);
    if (!sede) {
      logger.error("Sede no encontrada por su ID");
      return res.status(404).json({ error: "Sede no encontrada" });
    }
    logger.info("Sede obtenido correctamente por su ID");
    res.json(sede);
  } catch (error) {
    logger.error("Error al obtener el Sede mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Sede" });
  }
};

// Crear una Sede
exports.createSede = async (req, res) => {
  try {
    const sede = await Sede.create(req.body);
    logger.info("Sedes creado correctamente");
    res.status(201).json(sede);
  } catch (error) {
    logger.error("Error al crear un Sede: " + error.message);
    res.status(500).json({ error: "Error al crear Sede" });
  }
};

// Actualizar una Sede
exports.updateSede = async (req, res) => {
  try {
    const sede = await Sede.findByPk(req.params.id);
    if (!sede) {
      logger.error("Sede no encontrada por su ID");
      return res.status(404).json({ error: "Sede no encontrada" });
    }
    await sede.update(req.body);
    logger.info("Sedes actualizado correctamente");
    res.json(sede);
  } catch (error) {
    logger.error("Error al actualizar un Sede: " + error.message);
    res.status(500).json({ error: "Error al actualizar Sede" });
  }
};

// Eliminar una Sede
exports.deleteSede = async (req, res) => {
  try {
    const sede = await Sede.findByPk(req.params.id);
    if (!sede) {
      logger.error("Sede no encontrada por su ID");
      return res.status(404).json({ error: "Sede no encontrada" });
    }
    await Sede.destroy();
    logger.info("Sedes eliminado correctamente");
    res.json({ message: "Sede eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Sede: " + error.message);
    res.status(500).json({ error: "Error al eliminar Sede" });
  }
};

