const {Servicio} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Servicioes
exports.getServicioAll = async (req, res) => {
  try {
    const servicios = await Servicio.findAll();
    logger.info("Servicios obtenidos correctamente");
    res.json(servicios);
  } catch (error) {
    logger.error("Error al obtener Servicios: " + error.message);
    res.status(500).json({ error: "Error al obtener Servicioes" });
  }
};

// Obtener una Servicio por ID
exports.getServicioById = async (req, res) => {
  try {
    const servicio = await Servicio.findByPk(req.params.id);
    if (!servicio) {
      logger.error("Servicio no encontrada por su ID");
      return res.status(404).json({ error: "Servicio no encontrada" });
    }
    logger.info("Servicio obtenido correctamente por su ID");
    res.json(servicio);
  } catch (error) {
    logger.error("Error al obtener el Servicio mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Servicio" });
  }
};

// Crear una Servicio
exports.createServicio = async (req, res) => {
  try {
    const servicio = await Servicio.create(req.body);
    logger.info("Servicios creado correctamente");
    res.status(201).json(servicio);
  } catch (error) {
    logger.error("Error al crear un Servicio: " + error.message);
    res.status(500).json({ error: "Error al crear Servicio" });
  }
};

// Actualizar una Servicio
exports.updateServicio = async (req, res) => {
  try {
    const servicio = await Servicio.findByPk(req.params.id);
    if (!servicio) {
      logger.error("Servicio no encontrada por su ID");
      return res.status(404).json({ error: "Servicio no encontrada" });
    }
    await servicio.update(req.body);
    logger.info("Servicios actualizado correctamente");
    res.json(servicio);
  } catch (error) {
    logger.error("Error al actualizar un Servicio: " + error.message);
    res.status(500).json({ error: "Error al actualizar Servicio" });
  }
};

// Eliminar una Servicio
exports.deleteServicio = async (req, res) => {
  try {
    const servicio = await Servicio.findByPk(req.params.id);
    if (!servicio) {
      logger.error("Servicio no encontrada por su ID");
      return res.status(404).json({ error: "Servicio no encontrada" });
    }
    await Servicio.destroy();
    logger.info("Servicios eliminado correctamente");
    res.json({ message: "Servicio eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Servicio: " + error.message);
    res.status(500).json({ error: "Error al eliminar Servicio" });
  }
};

