const {SubCategoriaInventario, CategoriaInventario} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las SubCategoriaInventarioes
exports.getSubCategoriaInventarioAll = async (req, res) => {
  try {
    const datos = await SubCategoriaInventario.findAll(
      {
        order: [['Nombre', 'ASC']],
        include: [
          {
            model: CategoriaInventario,
            as: 'categoria',
            attributes: ['id', 'Nombre']
          }
        ]
      }
    );
    logger.info("SubCategoriaInventarios obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener SubCategoriaInventarios: " + error.message);
    res.status(500).json({ error: "Error al obtener SubCategoriaInventarioes" });
  }
};

// Obtener todas las SubCategoriaInventarioes
exports.getSubCategoriaInventarioByCategoria = async (req, res) => {
  try {
    const { categoria } = req.params; 
    const datos = await SubCategoriaInventario.findAll(
      {
        where: {
          CategoriaInventarioId: categoria
        },
        include: [
          {
            model: CategoriaInventario,
            as: 'categoria',
            attributes: ['id', 'Nombre']
          }
        ],
        order: [['Nombre', 'ASC']]
      }
    );
    logger.info("SubCategoriaInventarios obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener SubCategoriaInventarios: " + error.message);
    res.status(500).json({ error: "Error al obtener SubCategoriaInventarioes" });
  }
};

// Obtener una SubCategoriaInventario por ID
exports.getSubCategoriaInventarioById = async (req, res) => {
  try {
    const dato = await SubCategoriaInventario.findByPk(req.params.id);
    if (!dato) {
      logger.error("SubCategoriaInventario no encontrada por su ID");
      return res.status(404).json({ error: "SubCategoriaInventario no encontrada" });
    }
    logger.info("SubCategoriaInventario obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el SubCategoriaInventario mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener SubCategoriaInventario" });
  }
};

// Crear una SubCategoriaInventario
exports.createSubCategoriaInventario = async (req, res) => {
  try {
    const dato = await SubCategoriaInventario.create(req.body);
    logger.info("SubCategoriaInventarios creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un SubCategoriaInventario: " + error.message);
    res.status(500).json({ error: "Error al crear SubCategoriaInventario" });
  }
};

// Actualizar una SubCategoriaInventario
exports.updateSubCategoriaInventario = async (req, res) => {
  try {
    const dato = await SubCategoriaInventario.findByPk(req.params.id);
    if (!dato) {
      logger.error("SubCategoriaInventario no encontrada por su ID");
      return res.status(404).json({ error: "SubCategoriaInventario no encontrada" });
    }
    await dato.update(req.body);
    logger.info("SubCategoriaInventarios actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un SubCategoriaInventario: " + error.message);
    res.status(500).json({ error: "Error al actualizar SubCategoriaInventario" });
  }
};

// Eliminar una SubCategoriaInventario
exports.deleteSubCategoriaInventario = async (req, res) => {
  try {
    const dato = await SubCategoriaInventario.findByPk(req.params.id);
    if (!dato) {
      logger.error("SubCategoriaInventario no encontrada por su ID");
      return res.status(404).json({ error: "SubCategoriaInventario no encontrada" });
    }
    await SubCategoriaInventario.destroy();
    logger.info("SubCategoriaInventarios eliminado correctamente");
    res.json({ message: "SubCategoriaInventario eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un SubCategoriaInventario: " + error.message);
    res.status(500).json({ error: "Error al eliminar SubCategoriaInventario" });
  }
};

