const {SubCategoriaPatrimonio, CategoriaPatrimonio} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las SubCategoriaPatrimonioes
exports.getSubCategoriaPatrimonioAll = async (req, res) => {
  try {
    const datos = await SubCategoriaPatrimonio.findAll(
      {
        order: [['Nombre', 'ASC']],
        include: [
          {
            model: CategoriaPatrimonio,
            as: 'categoria',
            attributes: ['id', 'Nombre']
          }
        ]
      }
    );
    logger.info("SubCategoriaPatrimonios obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener SubCategoriaPatrimonios: " + error.message);
    res.status(500).json({ error: "Error al obtener SubCategoriaPatrimonioes" });
  }
};

// Obtener todas las SubCategoriaPatrimonioes
exports.getSubCategoriaPatrimonioByCategoria = async (req, res) => {
  try {
    const { categoria } = req.params; 
    const datos = await SubCategoriaPatrimonio.findAll(
      {
        where: {
          CategoriaPatrimonioId: categoria
        },
        include: [
          {
            model: CategoriaPatrimonio,
            as: 'categoria',
            attributes: ['id', 'Nombre']
          }
        ],
        order: [['Nombre', 'ASC']]
      }
    );
    logger.info("SubCategoriaPatrimonios obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener SubCategoriaPatrimonios: " + error.message);
    res.status(500).json({ error: "Error al obtener SubCategoriaPatrimonioes" });
  }
};

// Obtener una SubCategoriaPatrimonio por ID
exports.getSubCategoriaPatrimonioById = async (req, res) => {
  try {
    const dato = await SubCategoriaPatrimonio.findByPk(req.params.id);
    if (!dato) {
      logger.error("SubCategoriaPatrimonio no encontrada por su ID");
      return res.status(404).json({ error: "SubCategoriaPatrimonio no encontrada" });
    }
    logger.info("SubCategoriaPatrimonio obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el SubCategoriaPatrimonio mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener SubCategoriaPatrimonio" });
  }
};

// Crear una SubCategoriaPatrimonio
exports.createSubCategoriaPatrimonio = async (req, res) => {
  try {
    const dato = await SubCategoriaPatrimonio.create(req.body);
    logger.info("SubCategoriaPatrimonios creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un SubCategoriaPatrimonio: " + error.message);
    res.status(500).json({ error: "Error al crear SubCategoriaPatrimonio" });
  }
};

// Actualizar una SubCategoriaPatrimonio
exports.updateSubCategoriaPatrimonio = async (req, res) => {
  try {
    const dato = await SubCategoriaPatrimonio.findByPk(req.params.id);
    if (!dato) {
      logger.error("SubCategoriaPatrimonio no encontrada por su ID");
      return res.status(404).json({ error: "SubCategoriaPatrimonio no encontrada" });
    }
    await dato.update(req.body);
    logger.info("SubCategoriaPatrimonios actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un SubCategoriaPatrimonio: " + error.message);
    res.status(500).json({ error: "Error al actualizar SubCategoriaPatrimonio" });
  }
};

// Eliminar una SubCategoriaPatrimonio
exports.deleteSubCategoriaPatrimonio = async (req, res) => {
  try {
    const dato = await SubCategoriaPatrimonio.findByPk(req.params.id);
    if (!dato) {
      logger.error("SubCategoriaPatrimonio no encontrada por su ID");
      return res.status(404).json({ error: "SubCategoriaPatrimonio no encontrada" });
    }
    await SubCategoriaPatrimonio.destroy();
    logger.info("SubCategoriaPatrimonios eliminado correctamente");
    res.json({ message: "SubCategoriaPatrimonio eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un SubCategoriaPatrimonio: " + error.message);
    res.status(500).json({ error: "Error al eliminar SubCategoriaPatrimonio" });
  }
};

