const {SubItemLaboratorio, ItemLaboratorio} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las SubItemLaboratorioes
exports.getSubItemLaboratorioAll = async (req, res) => {
  try {
    const datos = await SubItemLaboratorio.findAll(
      {
        include: [
          {
            model: ItemLaboratorio,
            as: "item",
          }
        ]
      }
    );
    logger.info("SubItemLaboratorios obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener SubItemLaboratorios: " + error.message);
    res.status(500).json({ error: "Error al obtener SubItemLaboratorioes" });
  }
};
// Obtener una SubItemLaboratorio por Empresa
exports.getSubItemLaboratorioByItemLaboratorio = async (req, res) => {
  try {
    const { itemlaboratorio } = req.params;
    const datos = await SubItemLaboratorio.findAll(
      {
        where: {
          ItemLaboratorioId: itemlaboratorio
        },
        include: [
          {
            model: ItemLaboratorio,
            as: "item",
          }
        ]
      }
    );
    if (!datos) {
      logger.error("SubItemLaboratorio no encontrada por su asociacion con paciente");
      return res.status(404).json({ error: "SubItemLaboratorios no encontrada" });
    }
    logger.info("SubItemLaboratorios obtenidas correctamente por su asociacion con el paciente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el SubItemLaboratorio mediante por paciente: " + error.message);
    res.status(500).json({ error: "Error al obtener SubItemLaboratorios" });
  }
};

// Obtener una SubItemLaboratorio por ID
exports.getSubItemLaboratorioById = async (req, res) => {
  try {
    const dato = await SubItemLaboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("SubItemLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "SubItemLaboratorio no encontrada" });
    }
    logger.info("SubItemLaboratorio obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el SubItemLaboratorio mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener SubItemLaboratorio" });
  }
};

// Crear una SubItemLaboratorio
exports.createSubItemLaboratorio = async (req, res) => {
  try {
    const dato = await SubItemLaboratorio.create(req.body);
    logger.info("SubItemLaboratorios creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un SubItemLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al crear SubItemLaboratorio" });
  }
};

// Actualizar una SubItemLaboratorio
exports.updateSubItemLaboratorio = async (req, res) => {
  try {
    const dato = await SubItemLaboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("SubItemLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "SubItemLaboratorio no encontrada" });
    }
    await dato.update(req.body);
    logger.info("SubItemLaboratorio actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un SubItemLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al actualizar SubItemLaboratorio" });
  }
};

// Eliminar una SubItemLaboratorio
exports.deleteSubItemLaboratorio = async (req, res) => {
  try {
    const dato = await SubItemLaboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("SubItemLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "SubItemLaboratorio no encontrada" });
    }
    await SubItemLaboratorio.destroy();
    logger.info("SubItemLaboratorio eliminado correctamente");
    res.json({ message: "SubItemLaboratorio eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un SubItemLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al eliminar SubItemLaboratorio" });
  }
};

