const {TipoActividad} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las TipoActividades
exports.getTipoActividadAll = async (req, res) => {
  try {
    const TiposActividad = await TipoActividad.findAll();
    logger.info("Tipos Actividad obtenidos correctamente");
    res.json(TiposActividad);
  } catch (error) {
    logger.error("Error al obtener Tipos Actividad: " + error.message);
    res.status(500).json({ error: "Error al obtener TipoActividades" });
  }
};

// Obtener una Tipo Actividad por ID
exports.getTipoActividadById = async (req, res) => {
  try {
    const tipoActividad = await TipoActividad.findByPk(req.params.id);
    if (!tipoActividad) {
      logger.error("Tipo Actividad no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Actividad no encontrada" });
    }
    logger.info("Tipo Actividad obtenido correctamente por su ID");
    res.json(tipoActividad);
  } catch (error) {
    logger.error("Error al obtener el Tipo Actividad mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Tipo Actividad" });
  }
};

// Crear una Tipo Actividad
exports.createTipoActividad = async (req, res) => {
  try {
    const tipoActividad = await TipoActividad.create(req.body);
    logger.info("Tipo Actividad creado correctamente");
    res.status(201).json(tipoActividad);
  } catch (error) {
    logger.error("Error al crear un Tipo Actividad: " + error.message);
    res.status(500).json({ error: "Error al crear Tipo Actividad" });
  }
};

// Actualizar una Tipo Actividad
exports.updateTipoActividad = async (req, res) => {
  try {
    const tipoActividad = await TipoActividad.findByPk(req.params.id);
    if (!tipoActividad) {
      logger.error("Tipo Actividad no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Actividad no encontrada" });
    }
    await tipoActividad.update(req.body);
    logger.info("Tipo Actividad actualizado correctamente");
    res.json(tipoActividad);
  } catch (error) {
    logger.error("Error al actualizar un Tipo Actividad: " + error.message);
    res.status(500).json({ error: "Error al actualizar Tipo Actividad" });
  }
};

// Eliminar una Tipo Actividad
exports.deleteTipoActividad = async (req, res) => {
  try {
    const tipoActividad = await TipoActividad.findByPk(req.params.id);
    if (!tipoActividad) {
      logger.error("Tipo Actividad no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Actividad no encontrada" });
    }
    await TipoActividad.destroy();
    logger.info("Tipo Actividad eliminado correctamente");
    res.json({ message: "Tipo Actividad eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Tipo Actividad: " + error.message);
    res.status(500).json({ error: "Error al eliminar Tipo Actividad" });
  }
};

