const {TipoAfiliacion} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las TipoAfiliaciones
exports.getTipoAfiliacionAll = async (req, res) => {
  try {
    const tiposafiliacion = await TipoAfiliacion.findAll();
    logger.info("TipoAfiliacions obtenidos correctamente");
    res.json(tiposafiliacion);
  } catch (error) {
    logger.error("Error al obtener TipoAfiliacions: " + error.message);
    res.status(500).json({ error: "Error al obtener TipoAfiliaciones" });
  }
};

// Obtener una Tipo Afiliacion por ID
exports.getTipoAfiliacionById = async (req, res) => {
  try {
    const tipoafiliacion = await TipoAfiliacion.findByPk(req.params.id);
    if (!tipoafiliacion) {
      logger.error("Tipo Afiliacion no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Afiliacion no encontrada" });
    }
    logger.info("Tipo Afiliacion obtenido correctamente por su ID");
    res.json(tipoafiliacion);
  } catch (error) {
    logger.error("Error al obtener el Tipo Afiliacion mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Tipo Afiliacion" });
  }
};

// Crear una Tipo Afiliacion
exports.createTipoAfiliacion = async (req, res) => {
  try {
    const tipoafiliacion = await TipoAfiliacion.create(req.body);
    logger.info("Tipo Afiliacion creado correctamente");
    res.status(201).json(tipoafiliacion);
  } catch (error) {
    logger.error("Error al crear un Tipo Afiliacion: " + error.message);
    res.status(500).json({ error: "Error al crear Tipo Afiliacion" });
  }
};

// Actualizar una Tipo Afiliacion
exports.updateTipoAfiliacion = async (req, res) => {
  try {
    const tipoafiliacion = await TipoAfiliacion.findByPk(req.params.id);
    if (!tipoafiliacion) {
      logger.error("Tipo Afiliacion no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Afiliacion no encontrada" });
    }
    await tipoafiliacion.update(req.body);
    logger.info("Tipo Afiliacion actualizado correctamente");
    res.json(tipoafiliacion);
  } catch (error) {
    logger.error("Error al actualizar un Tipo Afiliacion: " + error.message);
    res.status(500).json({ error: "Error al actualizar Tipo Afiliacion" });
  }
};

// Eliminar una Tipo Afiliacion
exports.deleteTipoAfiliacion = async (req, res) => {
  try {
    const tipoafiliacion = await TipoAfiliacion.findByPk(req.params.id);
    if (!tipoafiliacion) {
      logger.error("Tipo Afiliacion no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Afiliacion no encontrada" });
    }
    await TipoAfiliacion.destroy();
    logger.info("Tipo Afiliacion eliminado correctamente");
    res.json({ message: "Tipo Afiliacion eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Tipo Afiliacion: " + error.message);
    res.status(500).json({ error: "Error al eliminar Tipo Afiliacion" });
  }
};

