const {TipoCampania} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las TipoCampaniaes
exports.getTipoCampaniaAll = async (req, res) => {
  try {
    const TiposCampania = await TipoCampania.findAll();
    logger.info("Tipos Campania obtenidos correctamente");
    res.json(TiposCampania);
  } catch (error) {
    logger.error("Error al obtener Tipos Campania: " + error.message);
    res.status(500).json({ error: "Error al obtener TipoCampaniaes" });
  }
};

// Obtener una Tipo Campania por ID
exports.getTipoCampaniaById = async (req, res) => {
  try {
    const tipoCampania = await TipoCampania.findByPk(req.params.id);
    if (!tipoCampania) {
      logger.error("Tipo Campania no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Campania no encontrada" });
    }
    logger.info("Tipo Campania obtenido correctamente por su ID");
    res.json(tipoCampania);
  } catch (error) {
    logger.error("Error al obtener el Tipo Campania mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Tipo Campania" });
  }
};

// Crear una Tipo Campania
exports.createTipoCampania = async (req, res) => {
  try {
    const tipoCampania = await TipoCampania.create(req.body);
    logger.info("Tipo Campania creado correctamente");
    res.status(201).json(tipoCampania);
  } catch (error) {
    logger.error("Error al crear un Tipo Campania: " + error.message);
    res.status(500).json({ error: "Error al crear Tipo Campania" });
  }
};

// Actualizar una Tipo Campania
exports.updateTipoCampania = async (req, res) => {
  try {
    const tipoCampania = await TipoCampania.findByPk(req.params.id);
    if (!tipoCampania) {
      logger.error("Tipo Campania no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Campania no encontrada" });
    }
    await tipoCampania.update(req.body);
    logger.info("Tipo Campania actualizado correctamente");
    res.json(tipoCampania);
  } catch (error) {
    logger.error("Error al actualizar un Tipo Campania: " + error.message);
    res.status(500).json({ error: "Error al actualizar Tipo Campania" });
  }
};

// Eliminar una Tipo Campania
exports.deleteTipoCampania = async (req, res) => {
  try {
    const tipoCampania = await TipoCampania.findByPk(req.params.id);
    if (!tipoCampania) {
      logger.error("Tipo Campania no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Campania no encontrada" });
    }
    await TipoCampania.destroy();
    logger.info("Tipo Campania eliminado correctamente");
    res.json({ message: "Tipo Campania eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Tipo Campania: " + error.message);
    res.status(500).json({ error: "Error al eliminar Tipo Campania" });
  }
};

