const {TipoConcentimiento} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las TipoConcentimientoes
exports.getTipoConcentimientoAll = async (req, res) => {
  try {
    const tipos = await TipoConcentimiento.findAll();
    logger.info("TipoConcentimientos obtenidos correctamente");
    res.json(tipos);
  } catch (error) {
    logger.error("Error al obtener TipoConcentimientos: " + error.message);
    res.status(500).json({ error: "Error al obtener TipoConcentimientoes" });
  }
};

// Obtener una TipoConcentimiento por ID
exports.getTipoConcentimientoById = async (req, res) => {
  try {
    const tipo = await TipoConcentimiento.findByPk(req.params.id);
    if (!tipo) {
      logger.error("TipoConcentimiento no encontrada por su ID");
      return res.status(404).json({ error: "TipoConcentimiento no encontrada" });
    }
    logger.info("TipoConcentimiento obtenido correctamente por su ID");
    res.json(tipo);
  } catch (error) {
    logger.error("Error al obtener el TipoConcentimiento mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener TipoConcentimiento" });
  }
};

// Crear una TipoConcentimiento
exports.createTipoConcentimiento = async (req, res) => {
  try {
    const tipo = await TipoConcentimiento.create(req.body);
    logger.info("TipoConcentimientos creado correctamente");
    res.status(201).json(tipo);
  } catch (error) {
    logger.error("Error al crear un TipoConcentimiento: " + error.message);
    res.status(500).json({ error: "Error al crear TipoConcentimiento" });
  }
};

// Actualizar una TipoConcentimiento
exports.updateTipoConcentimiento = async (req, res) => {
  try {
    const tipo = await TipoConcentimiento.findByPk(req.params.id);
    if (!tipo) {
      logger.error("TipoConcentimiento no encontrada por su ID");
      return res.status(404).json({ error: "TipoConcentimiento no encontrada" });
    }
    await tipo.update(req.body);
    logger.info("TipoConcentimiento actualizado correctamente");
    res.json(tipo);
  } catch (error) {
    logger.error("Error al actualizar un TipoConcentimiento: " + error.message);
    res.status(500).json({ error: "Error al actualizar TipoConcentimiento" });
  }
};

// Eliminar una TipoConcentimiento
exports.deleteTipoConcentimiento = async (req, res) => {
  try {
    const tipo = await TipoConcentimiento.findByPk(req.params.id);
    if (!tipo) {
      logger.error("TipoConcentimiento no encontrada por su ID");
      return res.status(404).json({ error: "TipoConcentimiento no encontrada" });
    }
    await TipoConcentimiento.destroy();
    logger.info("TipoConcentimiento eliminado correctamente");
    res.json({ message: "TipoConcentimiento eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un TipoConcentimiento: " + error.message);
    res.status(500).json({ error: "Error al eliminar TipoConcentimiento" });
  }
};

