const {TipoDiente} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las TipoDientees
exports.getTipoDienteAll = async (req, res) => {
  try {
    const tipos = await TipoDiente.findAll();
    logger.info("TipoDientes obtenidos correctamente");
    res.json(tipos);
  } catch (error) {
    logger.error("Error al obtener TipoDientes: " + error.message);
    res.status(500).json({ error: "Error al obtener TipoDientees" });
  }
};

// Obtener una TipoDiente por ID
exports.getTipoDienteById = async (req, res) => {
  try {
    const tipo = await TipoDiente.findByPk(req.params.id);
    if (!tipo) {
      logger.error("TipoDiente no encontrada por su ID");
      return res.status(404).json({ error: "TipoDiente no encontrada" });
    }
    logger.info("TipoDiente obtenido correctamente por su ID");
    res.json(tipo);
  } catch (error) {
    logger.error("Error al obtener el TipoDiente mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener TipoDiente" });
  }
};

// Crear una TipoDiente
exports.createTipoDiente = async (req, res) => {
  try {
    const tipo = await TipoDiente.create(req.body);
    logger.info("TipoDientes creado correctamente");
    res.status(201).json(tipo);
  } catch (error) {
    logger.error("Error al crear un TipoDiente: " + error.message);
    res.status(500).json({ error: "Error al crear TipoDiente" });
  }
};

// Actualizar una TipoDiente
exports.updateTipoDiente = async (req, res) => {
  try {
    const tipo = await TipoDiente.findByPk(req.params.id);
    if (!tipo) {
      logger.error("TipoDiente no encontrada por su ID");
      return res.status(404).json({ error: "TipoDiente no encontrada" });
    }
    await tipo.update(req.body);
    logger.info("TipoDiente actualizado correctamente");
    res.json(tipo);
  } catch (error) {
    logger.error("Error al actualizar un TipoDiente: " + error.message);
    res.status(500).json({ error: "Error al actualizar TipoDiente" });
  }
};

// Eliminar una TipoDiente
exports.deleteTipoDiente = async (req, res) => {
  try {
    const tipo = await TipoDiente.findByPk(req.params.id);
    if (!tipo) {
      logger.error("TipoDiente no encontrada por su ID");
      return res.status(404).json({ error: "TipoDiente no encontrada" });
    }
    await TipoDiente.destroy();
    logger.info("TipoDiente eliminado correctamente");
    res.json({ message: "TipoDiente eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un TipoDiente: " + error.message);
    res.status(500).json({ error: "Error al eliminar TipoDiente" });
  }
};

