const {TipoDocPDF} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las TipoDocPDFes
exports.getTipoDocPDFAll = async (req, res) => {
  try {
    const datos = await TipoDocPDF.findAll();
    logger.info("TipoDocPDFs obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener TipoDocPDFs: " + error.message);
    res.status(500).json({ error: "Error al obtener TipoDocPDFes" });
  }
};

// Obtener una TipoDocPDF por ID
exports.getTipoDocPDFById = async (req, res) => {
  try {
    const dato = await TipoDocPDF.findByPk(req.params.id);
    if (!dato) {
      logger.error("TipoDocPDF no encontrada por su ID");
      return res.status(404).json({ error: "TipoDocPDF no encontrada" });
    }
    logger.info("TipoDocPDF obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el TipoDocPDF mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener TipoDocPDF" });
  }
};

// Crear una TipoDocPDF
exports.createTipoDocPDF = async (req, res) => {
  try {
    const dato = await TipoDocPDF.create(req.body);
    logger.info("TipoDocPDFs creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un TipoDocPDF: " + error.message);
    res.status(500).json({ error: "Error al crear TipoDocPDF" });
  }
};

// Actualizar una TipoDocPDF
exports.updateTipoDocPDF = async (req, res) => {
  try {
    const dato = await TipoDocPDF.findByPk(req.params.id);
    if (!dato) {
      logger.error("TipoDocPDF no encontrada por su ID");
      return res.status(404).json({ error: "TipoDocPDF no encontrada" });
    }
    await dato.update(req.body);
    logger.info("TipoDocPDFs actualizado correctamente");
    res.json(TipoDocPDF);
  } catch (error) {
    logger.error("Error al actualizar un TipoDocPDF: " + error.message);
    res.status(500).json({ error: "Error al actualizar TipoDocPDF" });
  }
};

// Eliminar una TipoDocPDF
exports.deleteTipoDocPDF = async (req, res) => {
  try {
    const dato = await TipoDocPDF.findByPk(req.params.id);
    if (!dato) {
      logger.error("TipoDocPDF no encontrada por su ID");
      return res.status(404).json({ error: "TipoDocPDF no encontrada" });
    }
    await TipoDocPDF.destroy();
    logger.info("TipoDocPDFs eliminado correctamente");
    res.json({ message: "TipoDocPDF eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un TipoDocPDF: " + error.message);
    res.status(500).json({ error: "Error al eliminar TipoDocPDF" });
  }
};

