const {TipoDocumento} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las TipoDocumentoes
exports.getTipoDocumentoAll = async (req, res) => {
  try {
    const tiposdocumento = await TipoDocumento.findAll();
    logger.info("Tipos Documentos obtenidos correctamente");
    res.json(tiposdocumento);
  } catch (error) {
    logger.error("Error al obtener Tipos Documento: " + error.message);
    res.status(500).json({ error: "Error al obtener Tipos Documento" });
  }
};

// Obtener una Tipo Documento por ID
exports.getTipoDocumentoById = async (req, res) => {
  try {
    const tipodocumento = await TipoDocumento.findByPk(req.params.id);
    if (!tipodocumento) {
      logger.error("Tipo Documento no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Documento no encontrada" });
    }
    logger.info("Tipo Documento obtenido correctamente por su ID");
    res.json(tipodocumento);
  } catch (error) {
    logger.error("Error al obtener el Tipo Documento mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Tipo Documento" });
  }
};

// Crear una Tipo Documento
exports.createTipoDocumento = async (req, res) => {
  try {
    const tipodocumento = await TipoDocumento.create(req.body);
    logger.info("Tipo Documento creado correctamente");
    res.status(201).json(tipodocumento);
  } catch (error) {
    logger.error("Error al crear un Tipo Documento: " + error.message);
    res.status(500).json({ error: "Error al crear Tipo Documento" });
  }
};

// Actualizar una Tipo Documento
exports.updateTipoDocumento = async (req, res) => {
  try {
    const tipodocumento = await TipoDocumento.findByPk(req.params.id);
    if (!tipodocumento) {
      logger.error("Tipo Documento no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Documento no encontrada" });
    }
    await tipodocumento.update(req.body);
    logger.info("Tipo Documento actualizado correctamente");
    res.json(tipodocumento);
  } catch (error) {
    logger.error("Error al actualizar un Tipo Documento: " + error.message);
    res.status(500).json({ error: "Error al actualizar Tipo Documento" });
  }
};

// Eliminar una Tipo Documento
exports.deleteTipoDocumento = async (req, res) => {
  try {
    const tipodocumento = await TipoDocumento.findByPk(req.params.id);
    if (!tipodocumento) {
      logger.error("Tipo Documento no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Documento no encontrada" });
    }
    await TipoDocumento.destroy();
    logger.info("Tipo Documento eliminado correctamente");
    res.json({ message: "Tipo Documento eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Tipo Documento: " + error.message);
    res.status(500).json({ error: "Error al eliminar Tipo Documento" });
  }
};

