const {TipoIncidencia} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las TipoIncidenciaes
exports.getTipoIncidenciaAll = async (req, res) => {
  try {
    const tiposincidencia = await TipoIncidencia.findAll();
    logger.info("Tipos Incidencia obtenidos correctamente");
    res.json(tiposincidencia);
  } catch (error) {
    logger.error("Error al obtener Tipos Incidencia: " + error.message);
    res.status(500).json({ error: "Error al obtener Tipos Incidencia" });
  }
};

// Obtener una Tipo Incidencia por ID
exports.getTipoIncidenciaById = async (req, res) => {
  try {
    const tipoincidencia = await TipoIncidencia.findByPk(req.params.id);
    if (!tipoincidencia) {
      logger.error("Tipo Incidencia no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Incidencia no encontrada" });
    }
    logger.info("Tipo Incidencia obtenido correctamente por su ID");
    res.json(tipoincidencia);
  } catch (error) {
    logger.error("Error al obtener el Tipo Incidencia mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Tipo Incidencia" });
  }
};

// Crear una Tipo Incidencia
exports.createTipoIncidencia = async (req, res) => {
  try {
    const tipoincidencia = await TipoIncidencia.create(req.body);
    logger.info("Tipo Incidencia creado correctamente");
    res.status(201).json(tipoincidencia);
  } catch (error) {
    logger.error("Error al crear un Tipo Incidencia: " + error.message);
    res.status(500).json({ error: "Error al crear Tipo Incidencia" });
  }
};

// Actualizar una Tipo Incidencia
exports.updateTipoIncidencia = async (req, res) => {
  try {
    const tipoincidencia = await TipoIncidencia.findByPk(req.params.id);
    if (!tipoincidencia) {
      logger.error("Tipo Incidencia no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Incidencia no encontrada" });
    }
    await tipoincidencia.update(req.body);
    logger.info("Tipo Incidencia actualizado correctamente");
    res.json(tipoincidencia);
  } catch (error) {
    logger.error("Error al actualizar un Tipo Incidencia: " + error.message);
    res.status(500).json({ error: "Error al actualizar Tipo Incidencia" });
  }
};

// Eliminar una Tipo Incidencia
exports.deleteTipoIncidencia = async (req, res) => {
  try {
    const tipoincidencia = await TipoIncidencia.findByPk(req.params.id);
    if (!tipoincidencia) {
      logger.error("Tipo Incidencia no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Incidencia no encontrada" });
    }
    await TipoIncidencia.destroy();
    logger.info("Tipo Incidencia eliminado correctamente");
    res.json({ message: "Tipo Incidencia eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Tipo Incidencia: " + error.message);
    res.status(500).json({ error: "Error al eliminar Tipo Incidencia" });
  }
};

