const {TipoIngreso} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las TipoIngresoes
exports.getTipoIngresoAll = async (req, res) => {
  try {
    const tiposIngreso = await TipoIngreso.findAll();
    logger.info("Tipos Ingreso obtenidos correctamente");
    res.json(tiposIngreso);
  } catch (error) {
    logger.error("Error al obtener Tipos Ingreso: " + error.message);
    res.status(500).json({ error: "Error al obtener TipoIngresoes" });
  }
};

// Obtener una Tipo Ingreso por ID
exports.getTipoIngresoById = async (req, res) => {
  try {
    const tipoIngreso = await TipoIngreso.findByPk(req.params.id);
    if (!tipoIngreso) {
      logger.error("Tipo Ingreso no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Ingreso no encontrada" });
    }
    logger.info("Tipo Ingreso obtenido correctamente por su ID");
    res.json(tipoIngreso);
  } catch (error) {
    logger.error("Error al obtener el Tipo Ingreso mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Tipo Ingreso" });
  }
};

// Crear una Tipo Ingreso
exports.createTipoIngreso = async (req, res) => {
  try {
    const tipoIngreso = await TipoIngreso.create(req.body);
    logger.info("Tipo Ingreso creado correctamente");
    res.status(201).json(tipoIngreso);
  } catch (error) {
    logger.error("Error al crear un Tipo Ingreso: " + error.message);
    res.status(500).json({ error: "Error al crear Tipo Ingreso" });
  }
};

// Actualizar una Tipo Ingreso
exports.updateTipoIngreso = async (req, res) => {
  try {
    const tipoIngreso = await TipoIngreso.findByPk(req.params.id);
    if (!tipoIngreso) {
      logger.error("Tipo Ingreso no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Ingreso no encontrada" });
    }
    await tipoIngreso.update(req.body);
    logger.info("Tipo Ingreso actualizado correctamente");
    res.json(tipoIngreso);
  } catch (error) {
    logger.error("Error al actualizar un Tipo Ingreso: " + error.message);
    res.status(500).json({ error: "Error al actualizar Tipo Ingreso" });
  }
};

// Eliminar una Tipo Ingreso
exports.deleteTipoIngreso = async (req, res) => {
  try {
    const tipoIngreso = await TipoIngreso.findByPk(req.params.id);
    if (!tipoIngreso) {
      logger.error("Tipo Ingreso no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Ingreso no encontrada" });
    }
    await TipoIngreso.destroy();
    logger.info("Tipo Ingreso eliminado correctamente");
    res.json({ message: "Tipo Ingreso eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Tipo Ingreso: " + error.message);
    res.status(500).json({ error: "Error al eliminar Tipo Ingreso" });
  }
};

