const {TipoPago} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las TipoPagoes
exports.getTipoPagoAll = async (req, res) => {
  try {
    const TiposPago = await TipoPago.findAll();
    logger.info("Tipos Pago obtenidos correctamente");
    res.json(TiposPago);
  } catch (error) {
    logger.error("Error al obtener Tipos Pago: " + error.message);
    res.status(500).json({ error: "Error al obtener TipoPagoes" });
  }
};

// Obtener una Tipo Pago por ID
exports.getTipoPagoById = async (req, res) => {
  try {
    const tipoPago = await TipoPago.findByPk(req.params.id);
    if (!tipoPago) {
      logger.error("Tipo Pago no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Pago no encontrada" });
    }
    logger.info("Tipo Pago obtenido correctamente por su ID");
    res.json(tipoPago);
  } catch (error) {
    logger.error("Error al obtener el Tipo Pago mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Tipo Pago" });
  }
};

// Crear una Tipo Pago
exports.createTipoPago = async (req, res) => {
  try {
    const tipoPago = await TipoPago.create(req.body);
    logger.info("Tipo Pago creado correctamente");
    res.status(201).json(tipoPago);
  } catch (error) {
    logger.error("Error al crear un Tipo Pago: " + error.message);
    res.status(500).json({ error: "Error al crear Tipo Pago" });
  }
};

// Actualizar una Tipo Pago
exports.updateTipoPago = async (req, res) => {
  try {
    const tipoPago = await TipoPago.findByPk(req.params.id);
    if (!tipoPago) {
      logger.error("Tipo Pago no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Pago no encontrada" });
    }
    await tipoPago.update(req.body);
    logger.info("Tipo Pago actualizado correctamente");
    res.json(tipoPago);
  } catch (error) {
    logger.error("Error al actualizar un Tipo Pago: " + error.message);
    res.status(500).json({ error: "Error al actualizar Tipo Pago" });
  }
};

// Eliminar una Tipo Pago
exports.deleteTipoPago = async (req, res) => {
  try {
    const tipoPago = await TipoPago.findByPk(req.params.id);
    if (!tipoPago) {
      logger.error("Tipo Pago no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Pago no encontrada" });
    }
    await TipoPago.destroy();
    logger.info("Tipo Pago eliminado correctamente");
    res.json({ message: "Tipo Pago eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Tipo Pago: " + error.message);
    res.status(500).json({ error: "Error al eliminar Tipo Pago" });
  }
};

