const {TipoProveedor} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las TipoProveedores
exports.getTipoProveedorAll = async (req, res) => {
  try {
    const TiposProveedor = await TipoProveedor.findAll();
    logger.info("Tipos Proveedor obtenidos correctamente");
    res.json(TiposProveedor);
  } catch (error) {
    logger.error("Error al obtener Tipos Proveedor: " + error.message);
    res.status(500).json({ error: "Error al obtener TipoProveedores" });
  }
};

// Obtener una Tipo Proveedor por ID
exports.getTipoProveedorById = async (req, res) => {
  try {
    const tipoProveedor = await TipoProveedor.findByPk(req.params.id);
    if (!tipoProveedor) {
      logger.error("Tipo Proveedor no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Proveedor no encontrada" });
    }
    logger.info("Tipo Proveedor obtenido correctamente por su ID");
    res.json(tipoProveedor);
  } catch (error) {
    logger.error("Error al obtener el Tipo Proveedor mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Tipo Proveedor" });
  }
};

// Crear una Tipo Proveedor
exports.createTipoProveedor = async (req, res) => {
  try {
    const tipoProveedor = await TipoProveedor.create(req.body);
    logger.info("Tipo Proveedor creado correctamente");
    res.status(201).json(tipoProveedor);
  } catch (error) {
    logger.error("Error al crear un Tipo Proveedor: " + error.message);
    res.status(500).json({ error: "Error al crear Tipo Proveedor" });
  }
};

// Actualizar una Tipo Proveedor
exports.updateTipoProveedor = async (req, res) => {
  try {
    const tipoProveedor = await TipoProveedor.findByPk(req.params.id);
    if (!tipoProveedor) {
      logger.error("Tipo Proveedor no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Proveedor no encontrada" });
    }
    await tipoProveedor.update(req.body);
    logger.info("Tipo Proveedor actualizado correctamente");
    res.json(tipoProveedor);
  } catch (error) {
    logger.error("Error al actualizar un Tipo Proveedor: " + error.message);
    res.status(500).json({ error: "Error al actualizar Tipo Proveedor" });
  }
};

// Eliminar una Tipo Proveedor
exports.deleteTipoProveedor = async (req, res) => {
  try {
    const tipoProveedor = await TipoProveedor.findByPk(req.params.id);
    if (!tipoProveedor) {
      logger.error("Tipo Proveedor no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Proveedor no encontrada" });
    }
    await TipoProveedor.destroy();
    logger.info("Tipo Proveedor eliminado correctamente");
    res.json({ message: "Tipo Proveedor eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Tipo Proveedor: " + error.message);
    res.status(500).json({ error: "Error al eliminar Tipo Proveedor" });
  }
};

