const {TipoRespuesta} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las TipoRespuestaes
exports.getTipoRespuestaAll = async (req, res) => {
  try {
    const TiposRespuesta = await TipoRespuesta.findAll();
    logger.info("Tipos Respuesta obtenidos correctamente");
    res.json(TiposRespuesta);
  } catch (error) {
    logger.error("Error al obtener Tipos Respuesta: " + error.message);
    res.status(500).json({ error: "Error al obtener TipoRespuestaes" });
  }
};

// Obtener una Tipo Respuesta por ID
exports.getTipoRespuestaById = async (req, res) => {
  try {
    const tipoRespuesta = await TipoRespuesta.findByPk(req.params.id);
    if (!tipoRespuesta) {
      logger.error("Tipo Respuesta no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Respuesta no encontrada" });
    }
    logger.info("Tipo Respuesta obtenido correctamente por su ID");
    res.json(tipoRespuesta);
  } catch (error) {
    logger.error("Error al obtener el Tipo Respuesta mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Tipo Respuesta" });
  }
};

// Crear una Tipo Respuesta
exports.createTipoRespuesta = async (req, res) => {
  try {
    const tipoRespuesta = await TipoRespuesta.create(req.body);
    logger.info("Tipo Respuesta creado correctamente");
    res.status(201).json(tipoRespuesta);
  } catch (error) {
    logger.error("Error al crear un Tipo Respuesta: " + error.message);
    res.status(500).json({ error: "Error al crear Tipo Respuesta" });
  }
};

// Actualizar una Tipo Respuesta
exports.updateTipoRespuesta = async (req, res) => {
  try {
    const tipoRespuesta = await TipoRespuesta.findByPk(req.params.id);
    if (!tipoRespuesta) {
      logger.error("Tipo Respuesta no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Respuesta no encontrada" });
    }
    await tipoRespuesta.update(req.body);
    logger.info("Tipo Respuesta actualizado correctamente");
    res.json(tipoRespuesta);
  } catch (error) {
    logger.error("Error al actualizar un Tipo Respuesta: " + error.message);
    res.status(500).json({ error: "Error al actualizar Tipo Respuesta" });
  }
};

// Eliminar una Tipo Respuesta
exports.deleteTipoRespuesta = async (req, res) => {
  try {
    const tipoRespuesta = await TipoRespuesta.findByPk(req.params.id);
    if (!tipoRespuesta) {
      logger.error("Tipo Respuesta no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Respuesta no encontrada" });
    }
    await TipoRespuesta.destroy();
    logger.info("Tipo Respuesta eliminado correctamente");
    res.json({ message: "Tipo Respuesta eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Tipo Respuesta: " + error.message);
    res.status(500).json({ error: "Error al eliminar Tipo Respuesta" });
  }
};

