const {TipoUsuario} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las TipoUsuarioes
exports.getTipoUsuarioAll = async (req, res) => {
  try {
    const TiposUsuario = await TipoUsuario.findAll();
    logger.info("TipoUsuarios obtenidos correctamente");
    res.json(TiposUsuario);
  } catch (error) {
    logger.error("Error al obtener TipoUsuarios: " + error.message);
    res.status(500).json({ error: "Error al obtener TipoUsuarioes" });
  }
};

// Obtener una Tipo Usuario por ID
exports.getTipoUsuarioById = async (req, res) => {
  try {
    const tipoUsuario = await TipoUsuario.findByPk(req.params.id);
    if (!tipoUsuario) {
      logger.error("Tipo Usuario no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Usuario no encontrada" });
    }
    logger.info("Tipo Usuario obtenido correctamente por su ID");
    res.json(tipoUsuario);
  } catch (error) {
    logger.error("Error al obtener el Tipo Usuario mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Tipo Usuario" });
  }
};

// Crear una Tipo Usuario
exports.createTipoUsuario = async (req, res) => {
  try {
    const tipoUsuario = await TipoUsuario.create(req.body);
    logger.info("Tipo Usuario creado correctamente");
    res.status(201).json(tipoUsuario);
  } catch (error) {
    logger.error("Error al crear un Tipo Usuario: " + error.message);
    res.status(500).json({ error: "Error al crear Tipo Usuario" });
  }
};

// Actualizar una Tipo Usuario
exports.updateTipoUsuario = async (req, res) => {
  try {
    const tipoUsuario = await TipoUsuario.findByPk(req.params.id);
    if (!tipoUsuario) {
      logger.error("Tipo Usuario no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Usuario no encontrada" });
    }
    await tipoUsuario.update(req.body);
    logger.info("Tipo Usuario actualizado correctamente");
    res.json(tipoUsuario);
  } catch (error) {
    logger.error("Error al actualizar un Tipo Usuario: " + error.message);
    res.status(500).json({ error: "Error al actualizar Tipo Usuario" });
  }
};

// Eliminar una Tipo Usuario
exports.deleteTipoUsuario = async (req, res) => {
  try {
    const tipoUsuario = await TipoUsuario.findByPk(req.params.id);
    if (!tipoUsuario) {
      logger.error("Tipo Usuario no encontrada por su ID");
      return res.status(404).json({ error: "Tipo Usuario no encontrada" });
    }
    await TipoUsuario.destroy();
    logger.info("Tipo Usuario eliminado correctamente");
    res.json({ message: "Tipo Usuario eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Tipo Usuario: " + error.message);
    res.status(500).json({ error: "Error al eliminar Tipo Usuario" });
  }
};

