const {Tratamiento} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Tratamientoes
exports.getTratamientoAll = async (req, res) => {
  try {
    const datos = await Tratamiento.findAll();
    logger.info("Tratamientos obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener Tratamientos: " + error.message);
    res.status(500).json({ error: "Error al obtener Tratamientoes" });
  }
};

// Obtener Tratamiento por Plan Tratamiento
exports.getTratamientoByPlanTratamiento = async (req, res) => {
  try {
    const { plan } = req.params;
    const datos = await Tratamiento.findAll(
      {
        where: {
          PlanTratamientoId: plan
        }
      }
    );
    if (!datos) {
      logger.error("Tratamiento no encontrada por su asociacion con Plan Tratamiento");
      return res.status(404).json({ error: "Tratamientos no encontrada" });
    }
    logger.info("Tratamientos obtenidas correctamente por su asociacion con la Plan Tratamiento");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el Tratamiento mediante por Plan Tratamiento: " + error.message);
    res.status(500).json({ error: "Error al obtener Tratamientos" });
  }
};

// Obtener una Tratamiento por ID
exports.getTratamientoById = async (req, res) => {
  try {
    const dato = await Tratamiento.findByPk(req.params.id);
    if (!dato) {
      logger.error("Tratamiento no encontrada por su ID");
      return res.status(404).json({ error: "Tratamiento no encontrada" });
    }
    logger.info("Tratamiento obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el Tratamiento mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Tratamiento" });
  }
};

// Crear una Tratamiento
exports.createTratamiento = async (req, res) => {
  try {
    const dato = await Tratamiento.create(req.body);
    logger.info("Tratamientos creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un Tratamiento: " + error.message);
    res.status(500).json({ error: "Error al crear Tratamiento" });
  }
};

// Actualizar una Tratamiento
exports.updateTratamiento = async (req, res) => {
  try {
    const dato = await Tratamiento.findByPk(req.params.id);
    if (!dato) {
      logger.error("Tratamiento no encontrada por su ID");
      return res.status(404).json({ error: "Tratamiento no encontrada" });
    }
    await dato.update(req.body);
    logger.info("Tratamientos actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un Tratamiento: " + error.message);
    res.status(500).json({ error: "Error al actualizar Tratamiento" });
  }
};

// Eliminar una Tratamiento
exports.deleteTratamiento = async (req, res) => {
  try {
    const dato = await Tratamiento.findByPk(req.params.id);
    if (!dato) {
      logger.error("Tratamiento no encontrada por su ID");
      return res.status(404).json({ error: "Tratamiento no encontrada" });
    }
    await dato.destroy();
    logger.info("Tratamientos eliminado correctamente");
    res.json({ message: "Tratamiento eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Tratamiento: " + error.message);
    res.status(500).json({ error: "Error al eliminar Tratamiento" });
  }
};

