const {UbicacionPersona} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las ubicaciones
exports.getUbicacionAll = async (req, res) => {
  try {
    const ubicaciones = await UbicacionPersona.findAll();
    logger.info("Ubicacions obtenidos correctamente");
    res.json(ubicaciones);
  } catch (error) {
    logger.error("Error al obtener Ubicacions: " + error.message);
    res.status(500).json({ error: "Error al obtener ubicaciones" });
  }
};

// Filtrar ubicaciones por odontologoId
exports.filtrarPorTipoyParametro = async (req, res) => {
  try {
    const { parametro, tipo } = req.params;
    const ubicaciones = await UbicacionPersona.findAll(
      {
        where: {
          TipoRegistro: tipo,
          RegistroId: parametro
        }
      }
    );

    res.json(ubicaciones);
  } catch (error) {
    res.status(500).json({ error: "Error al filtrar ubicaciones por odontólogo" });
  }
};

// Obtener una ubicación por ID
exports.getUbicacionById = async (req, res) => {
  try {
    const ubicacion = await UbicacionPersona.findByPk(req.params.id);
    if (!ubicacion) {
      logger.error("Ubicación no encontrada por su ID");
      return res.status(404).json({ error: "Ubicación no encontrada" });
    }
    logger.info("Ubicacion obtenido correctamente por su ID");
    res.json(ubicacion);
  } catch (error) {
    logger.error("Error al obtener el Ubicacion mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener ubicación" });
  }
};

// Crear una ubicación
exports.createUbicacion = async (req, res) => {
  try {
    const ubicacion = await UbicacionPersona.create(req.body);
    logger.info("Ubicacions creado correctamente");
    res.status(201).json(ubicacion);
  } catch (error) {
    logger.error("Error al crear un Ubicacion: " + error.message);
    res.status(500).json({ error: "Error al crear ubicación" });
  }
};

// Actualizar una ubicación
exports.updateUbicacion = async (req, res) => {
  try {
    const ubicacion = await UbicacionPersona.findByPk(req.params.id);
    if (!ubicacion) {
      logger.error("Ubicación no encontrada por su ID");
      return res.status(404).json({ error: "Ubicación no encontrada" });
    }
    await ubicacion.update(req.body);
    logger.info("Ubicacions actualizado correctamente");
    res.json(ubicacion);
  } catch (error) {
    logger.error("Error al actualizar un Ubicacion: " + error.message);
    res.status(500).json({ error: "Error al actualizar ubicación" });
  }
};

// Eliminar una ubicación
exports.deleteUbicacion = async (req, res) => {
  try {
    const ubicacion = await UbicacionPersona.findByPk(req.params.id);
    if (!ubicacion) {
      logger.error("Ubicación no encontrada por su ID");
      return res.status(404).json({ error: "Ubicación no encontrada" });
    }
    await ubicacion.destroy();
    logger.info("Ubicacions eliminado correctamente");
    res.json({ message: "Ubicación eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Ubicacion: " + error.message);
    res.status(500).json({ error: "Error al eliminar ubicación" });
  }
};


// // Filtrar ubicaciones por país
// exports.filtrarPorPais = async (req, res) => {
//   try {
//     const { pais } = req.params;
//     const ubicaciones = await UbicacionPersona.findAll({ where: { pais } });

//     res.json(ubicaciones);
//   } catch (error) {
//     res.status(500).json({ error: "Error al filtrar ubicaciones por país" });
//   }
// };

// // Filtrar ubicaciones por departamento
// exports.filtrarPorDepartamento = async (req, res) => {
//   try {
//     const { departamento } = req.params;
//     const ubicaciones = await UbicacionPersona.findAll({ where: { departamento } });

//     res.json(ubicaciones);
//   } catch (error) {
//     res.status(500).json({ error: "Error al filtrar ubicaciones por departamento" });
//   }
// };

// // Filtrar ubicaciones por provincia
// exports.filtrarPorProvincia = async (req, res) => {
//   try {
//     const { provincia } = req.params;
//     const ubicaciones = await UbicacionPersona.findAll({ where: { provincia } });

//     res.json(ubicaciones);
//   } catch (error) {
//     res.status(500).json({ error: "Error al filtrar ubicaciones por provincia" });
//   }
// };

// // Filtrar ubicaciones por distrito
// exports.filtrarPorDistrito = async (req, res) => {
//   try {
//     const { distrito } = req.params;
//     const ubicaciones = await UbicacionPersona.findAll({ where: { distrito } });

//     res.json(ubicaciones);
//   } catch (error) {
//     res.status(500).json({ error: "Error al filtrar ubicaciones por distrito" });
//   }
// };
