const {
  sequelize
} = require('../models');
// Método para actualizar el índice de la base de datos
// las tablas que se actualizarán son las siguientes:
const tables = [
  'EstadoAgendamientos', 'EstadoIncidencia', 'EstadoPagos', 'EstadoUsuarios', 
  'FuenteCaptacions', 'Generos', 'GradoInstruccions', 'Relacions', 
  'Vinculacions', 'TipoAfiliacions', 'TipoIncidencia', 'TipoPagos', 
  'TipoUsuarios', 'EstadoCampania', 'EstadoOrdenLaboratorios', 'Periodos', 
  'TipoActividads', 'TipoCampania', 'TipoIngresos', 'TipoProveedors', 
  'TipoRespuesta', 'Servicios', 'Profesions', 'CargoUsuarios', 
  'TipoDocumentos', 'Empresas', 'Sedes', 'Iafas', 'TipoDocPDFs', 
  'CategoriaPatrimonios', 'SubCategoriaPatrimonios', 'Almacens', 
  'CategoriaInventarios', 'SubCategoriaInventarios', 'Radiografia', 
  'EmpresaRadiografia', 'ItemRadiografia', 'Laboratorios', 
  'EmpresaLaboratorios', 'ItemLaboratorios', 'SubItemLaboratorios', 
  'Categoria', 'Hallazgos', 'Catalogos', 'TipoDientes', 'Cuadrantes', 
  'Ubicacions', 'TipoConcentimientos', 'Usuarios', 'Pacientes', 
  'Diagnosticos', 'Dientes', 'EstadoDientes', 'Tarifarios', 'Procedimientos',
];

exports.updateIndex = async (req, res) => {
  try {
    for (const tableName of tables) {
      // Obtener el máximo ID de la tabla
      const [results] = await sequelize.query(
        `SELECT MAX(id) as max_id FROM "${tableName}"`
      );
      const maxId = results[0]?.max_id || 0;
      // Ajustar la secuencia al valor máximo + 1
      await sequelize.query(
        `SELECT setval(pg_get_serial_sequence('"${tableName}"', 'id'), ${maxId + 1}, false)`
      );
      console.log(`✅ Secuencia de la tabla ${tableName} ajustada a ${maxId + 1}`);
    }
    res.json({
      message: 'Indices Actualizados correctamente',
    });
  } catch (error) {
    console.error('❌ Error actualizando indices:', error);
  }
};