const {Vinculacion} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Vinculaciones
exports.getVinculacionAll = async (req, res) => {
  try {
    const Vinculaciones = await Vinculacion.findAll();
    logger.info("Vinculacions obtenidos correctamente");
    res.json(Vinculaciones);
  } catch (error) {
    logger.error("Error al obtener Vinculacions: " + error.message);
    res.status(500).json({ error: "Error al obtener Vinculaciones" });
  }
};

// Obtener una Vinculacion por ID
exports.getVinculacionById = async (req, res) => {
  try {
    const vinculacion = await Vinculacion.findByPk(req.params.id);
    if (!vinculacion) {
      logger.error("Vinculacion no encontrada por su ID");
      return res.status(404).json({ error: "Vinculacion no encontrada" });
    }
    logger.info("Vinculacion obtenido correctamente por su ID");
    res.json(vinculacion);
  } catch (error) {
    logger.error("Error al obtener el Vinculacion mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Vinculacion" });
  }
};

// Crear una Vinculacion
exports.createVinculacion = async (req, res) => {
  try {
    const vinculacion = await Vinculacion.create(req.body);
    logger.info("Vinculacions creado correctamente");
    res.status(201).json(vinculacion);
  } catch (error) {
    logger.error("Error al crear un Vinculacion: " + error.message);
    res.status(500).json({ error: "Error al crear Vinculacion" });
  }
};

// Actualizar una Vinculacion
exports.updateVinculacion = async (req, res) => {
  try {
    const vinculacion = await Vinculacion.findByPk(req.params.id);
    if (!vinculacion) {
      logger.error("Vinculacion no encontrada por su ID");
      return res.status(404).json({ error: "Vinculacion no encontrada" });
    }
    await vinculacion.update(req.body);
    logger.info("Vinculacions actualizado correctamente");
    res.json(vinculacion);
  } catch (error) {
    logger.error("Error al actualizar un Vinculacion: " + error.message);
    res.status(500).json({ error: "Error al actualizar Vinculacion" });
  }
};

// Eliminar una Vinculacion
exports.deleteVinculacion = async (req, res) => {
  try {
    const vinculacion = await Vinculacion.findByPk(req.params.id);
    if (!vinculacion) {
      logger.error("Vinculacion no encontrada por su ID");
      return res.status(404).json({ error: "Vinculacion no encontrada" });
    }
    await Vinculacion.destroy();
    logger.info("Vinculacions eliminado correctamente");
    res.json({ message: "Vinculacion eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Vinculacion: " + error.message);
    res.status(500).json({ error: "Error al eliminar Vinculacion" });
  }
};

