const dotenv = require("dotenv");
dotenv.config();
const API_KEY = process.env.API_KEY;
// Añade este log
console.log('API_KEY loaded:', !!API_KEY); // No imprimas el valor real por seguridad
exports.verifyToken = (req, res, next) => {
  const authHeader = req.header("Authorization");
  if (!authHeader) {
    return res.status(401).json({
      error: "Acceso denegado. Token requerido."
    });
  }
  // Espera el formato "Bearer <token>"
  const token = authHeader.replace("Bearer ", "").trim();
  if (token !== API_KEY) {
    return res.status(401).json({
      error: "Token inválido."
    });
  }
  next();
};
