const { createLogger, format, transports } = require("winston");

const logger = createLogger({
  level: "info",
  format: format.combine(
    format.timestamp({ format: "YYYY-MM-DD HH:mm:ss" }),
    format.printf(({ level, message, timestamp }) => `${timestamp} [${level.toUpperCase()}]: ${message}`)
  ),
  transports: [
    new transports.Console(), // Mostrar logs en consola
    new transports.File({ filename: "logs/error.log", level: "error" }), // Guardar errores en archivo
    new transports.File({ filename: "logs/combined.log" }), // Guardar todos los logs
  ],
});

module.exports = logger;
