const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('Accion', {
        id: {
            type: DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true
        },
        Descripcion: {
            type: DataTypes.STRING,
            allowNull: false
        },
        ResponsableDescripcion: {
            type: DataTypes.STRING,
            allowNull: false
        },
        FechaInicio: {
            type: DataTypes.DATE,
            allowNull: false
        },
        InformadoPor: {
            type: DataTypes.STRING,
            allowNull: false
        },
        AnalisisdeCausas: {
            type: DataTypes.STRING,
            allowNull: false
        },
        ResponsableAnalisis: {
            type: DataTypes.STRING,
            allowNull: false
        },
        FechaAnalisis: {
            type: DataTypes.DATE,
            allowNull: false
        },
        Accion: {
            type: DataTypes.STRING,
            allowNull: false
        },
        TipoAccion: {
            type: DataTypes.STRING,
            allowNull: false
        },
        ResponsableAccion: {
            type: DataTypes.STRING,
            allowNull: false
        },
        FechaInicioAccion: {
            type: DataTypes.DATE,
            allowNull: false
        },
        FechaCierreAccion: {
            type: DataTypes.DATE,
            allowNull: false
        },
        Verificacion: {
            type: DataTypes.STRING,
            allowNull: false
        },
        ResponsableVerificacion: {
            type: DataTypes.STRING,
            allowNull: false
        },
        FechaFinalizacion: {
            type: DataTypes.DATE,
            allowNull: false
        },
        HallazgoId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'Incidencia',
                key: 'id'
            }
        }
    });
};